/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.graylog.aws.AWSObjectMapper;
import org.graylog.aws.config.AWSConfigurationResource;
import org.graylog.aws.inputs.cloudtrail.CloudTrailCodec;
import org.graylog.aws.inputs.cloudtrail.CloudTrailInput;
import org.graylog.aws.inputs.cloudtrail.CloudTrailTransport;
import org.graylog.aws.inputs.cloudwatch.CloudWatchLogsInput;
import org.graylog.aws.inputs.codecs.CloudWatchFlowLogCodec;
import org.graylog.aws.inputs.codecs.CloudWatchRawLogCodec;
import org.graylog.aws.inputs.flowlogs.FlowLogsInput;
import org.graylog.aws.inputs.transports.KinesisTransport;
import org.graylog.aws.migrations.V20200505121200_EncryptAWSSecretKey;
import org.graylog.aws.processors.instancelookup.AWSInstanceNameLookupProcessor;
import org.graylog.aws.processors.instancelookup.InstanceLookupTable;
import org.graylog2.plugin.PluginModule;

public class AWSModule
extends PluginModule {
    protected void configure() {
        this.addCodec("AWSCloudTrail", CloudTrailCodec.class);
        this.addTransport("cloudtrail", CloudTrailTransport.class);
        this.addMessageInput(CloudTrailInput.class);
        this.addCodec("AWSFlowLog", CloudWatchFlowLogCodec.class);
        this.addCodec("AWSCloudWatchRawLog", CloudWatchRawLogCodec.class);
        this.addTransport("awskinesis", KinesisTransport.class);
        this.addMessageInput(FlowLogsInput.class);
        this.addMessageInput(CloudWatchLogsInput.class);
        this.addMessageProcessor(AWSInstanceNameLookupProcessor.class, AWSInstanceNameLookupProcessor.Descriptor.class);
        this.bind(InstanceLookupTable.class).asEagerSingleton();
        this.bind(ObjectMapper.class).annotatedWith(AWSObjectMapper.class).toInstance((Object)this.createObjectMapper());
        this.addMigration(V20200505121200_EncryptAWSSecretKey.class);
        this.addRestResource(AWSConfigurationResource.class);
    }

    private ObjectMapper createObjectMapper() {
        return new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

