/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.codecs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.aws.AWSObjectMapper;
import org.graylog.aws.cloudwatch.CloudWatchLogEntry;
import org.graylog.aws.cloudwatch.FlowLogMessage;
import org.graylog.aws.inputs.codecs.CloudWatchLogDataCodec;
import org.graylog.aws.inputs.flowlogs.IANAProtocolNumbers;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class CloudWatchFlowLogCodec
extends CloudWatchLogDataCodec {
    public static final String NAME = "AWSFlowLog";
    private final IANAProtocolNumbers protocolNumbers = new IANAProtocolNumbers();

    @Inject
    public CloudWatchFlowLogCodec(@Assisted Configuration configuration, @AWSObjectMapper ObjectMapper objectMapper) {
        super(configuration, objectMapper);
    }

    @Override
    @Nullable
    public Message decodeLogData(@Nonnull CloudWatchLogEntry logEvent, @Nonnull String logGroup, @Nonnull String logStream) {
        try {
            FlowLogMessage flowLogMessage = FlowLogMessage.fromLogEvent(logEvent);
            if (flowLogMessage == null) {
                return null;
            }
            String source = this.configuration.getString("override_source", "aws-flowlogs");
            Message result = new Message(this.buildSummary(flowLogMessage), source, flowLogMessage.getTimestamp());
            result.addFields(this.buildFields(flowLogMessage));
            result.addField("aws_log_group", (Object)logGroup);
            result.addField("aws_log_stream", (Object)logStream);
            result.addField("aws_source", (Object)true);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize AWS FlowLog record.", e);
        }
    }

    private String buildSummary(FlowLogMessage msg) {
        return msg.getInterfaceId() + " " + msg.getAction() + " " + this.protocolNumbers.lookup(msg.getProtocolNumber()) + " " + msg.getSourceAddress() + ":" + msg.getSourcePort() + " -> " + msg.getDestinationAddress() + ":" + msg.getDestinationPort();
    }

    private Map<String, Object> buildFields(final FlowLogMessage msg) {
        return new HashMap<String, Object>(){
            {
                this.put("account_id", msg.getAccountId());
                this.put("interface_id", msg.getInterfaceId());
                this.put("src_addr", msg.getSourceAddress());
                this.put("dst_addr", msg.getDestinationAddress());
                this.put("src_port", msg.getSourcePort());
                this.put("dst_port", msg.getDestinationPort());
                this.put("protocol_number", msg.getProtocolNumber());
                this.put("protocol", CloudWatchFlowLogCodec.this.protocolNumbers.lookup(msg.getProtocolNumber()));
                this.put("packets", msg.getPackets());
                this.put("bytes", msg.getBytes());
                this.put("capture_window_duration_seconds", Seconds.secondsBetween((ReadableInstant)msg.getCaptureWindowStart(), (ReadableInstant)msg.getCaptureWindowEnd()).getSeconds());
                this.put("action", msg.getAction());
                this.put("log_status", msg.getLogStatus());
            }
        };
    }

    public String getName() {
        return NAME;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        public ConfigurationRequest getRequestedConfiguration() {
            return new ConfigurationRequest();
        }

        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<CloudWatchFlowLogCodec> {
        public CloudWatchFlowLogCodec create(Configuration var1);

        public Config getConfig();
    }
}

