/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.codecs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.aws.AWSObjectMapper;
import org.graylog.aws.cloudwatch.CloudWatchLogEntry;
import org.graylog.aws.inputs.codecs.CloudWatchLogDataCodec;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.joda.time.DateTime;

public class CloudWatchRawLogCodec
extends CloudWatchLogDataCodec {
    public static final String NAME = "AWSCloudWatchRawLog";

    @Inject
    public CloudWatchRawLogCodec(@Assisted Configuration configuration, @AWSObjectMapper ObjectMapper objectMapper) {
        super(configuration, objectMapper);
    }

    @Override
    @Nullable
    public Message decodeLogData(@Nonnull CloudWatchLogEntry logEvent, @Nonnull String logGroup, @Nonnull String logStream) {
        try {
            String source = this.configuration.getString("override_source", "aws-raw-logs");
            Message result = new Message(logEvent.message, source, new DateTime(logEvent.timestamp));
            result.addField("aws_log_group", (Object)logGroup);
            result.addField("aws_log_stream", (Object)logStream);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize AWS FlowLog record.", e);
        }
    }

    public String getName() {
        return NAME;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<CloudWatchRawLogCodec> {
        public CloudWatchRawLogCodec create(Configuration var1);

        public Config getConfig();
    }
}

