/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;

public class SearchScroll
extends GenericResultAbstractAction {
    @VisibleForTesting
    static final int MAX_SCROLL_ID_LENGTH = 1900;
    private final String restMethodName;

    protected SearchScroll(Builder builder) {
        super(builder);
        if (builder.getScrollId().length() > 1900) {
            this.restMethodName = "POST";
            this.payload = "{\"scroll_id\":\"" + builder.getScrollId() + "\"}";
        } else {
            this.restMethodName = "GET";
        }
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_search/scroll";
    }

    @Override
    public String getRestMethodName() {
        return this.restMethodName;
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    public static class Builder
    extends AbstractMultiIndexActionBuilder<SearchScroll, Builder> {
        private final String scrollId;

        public Builder(String scrollId, String scroll) {
            this.scrollId = scrollId;
            if (scrollId.length() <= 1900) {
                this.setParameter("scroll_id", scrollId);
            }
            this.setParameter("scroll", scroll);
        }

        @Override
        public String getJoinedIndices() {
            if (this.indexNames.size() > 0) {
                return Joiner.on((char)',').join((Iterable)this.indexNames);
            }
            return null;
        }

        @Override
        public SearchScroll build() {
            return new SearchScroll(this);
        }

        public String getScrollId() {
            return this.scrollId;
        }
    }
}

