/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DateRangeAggregation
extends BucketAggregation {
    public static final String TYPE = "date_range";
    private List<DateRange> ranges = new LinkedList<DateRange>();

    public DateRangeAggregation(String name, JsonNode dateRangeAggregation) {
        super(name, dateRangeAggregation);
        if (dateRangeAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && dateRangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isArray()) {
            this.parseBuckets(dateRangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonNode buckets) {
        Iterator iterator = buckets.iterator();
        while (iterator.hasNext()) {
            JsonNode bucket;
            DateRange range = new DateRange(bucket, (bucket = (JsonNode)iterator.next()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).asDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).asDouble()) : null, bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).asLong(), bucket.has(String.valueOf((Object)AggregationField.FROM_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.FROM_AS_STRING)).asText() : null, bucket.has(String.valueOf((Object)AggregationField.TO_AS_STRING)) ? bucket.get(String.valueOf((Object)AggregationField.TO_AS_STRING)).asText() : null);
            this.ranges.add(range);
        }
    }

    public List<DateRange> getBuckets() {
        return this.ranges;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateRangeAggregation)) {
            return false;
        }
        DateRangeAggregation rhs = (DateRangeAggregation)o;
        return Objects.equals(this.getBuckets(), rhs.getBuckets());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getBuckets());
    }

    public class DateRange
    extends Range {
        private String fromAsString;
        private String toAsString;

        public DateRange(JsonNode bucket, Double from, Double to, Long count, String fromString, String toString) {
            super(bucket, from, to, count);
            this.fromAsString = fromString;
            this.toAsString = toString;
        }

        public String getFromAsString() {
            return this.fromAsString;
        }

        public String getToAsString() {
            return this.toAsString;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DateRange)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DateRange rhs = (DateRange)o;
            return Objects.equals(this.fromAsString, rhs.fromAsString) && Objects.equals(this.toAsString, rhs.toAsString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fromAsString, this.toAsString);
        }
    }
}

