/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.NormsProducer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocIDMerger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergeState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;

public abstract class NormsConsumer
implements Closeable {
    protected NormsConsumer() {
    }

    public abstract void addNormsField(FieldInfo var1, Iterable<Number> var2) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (NormsProducer normsProducer : mergeState.normsProducers) {
            if (normsProducer == null) continue;
            normsProducer.checkIntegrity();
        }
        for (FieldInfo mergeFieldInfo : mergeState.mergeFieldInfos) {
            if (!mergeFieldInfo.hasNorms()) continue;
            ArrayList<NumericDocValues> toMerge = new ArrayList<NumericDocValues>();
            for (int i = 0; i < mergeState.normsProducers.length; ++i) {
                FieldInfo fieldInfo;
                NormsProducer normsProducer = mergeState.normsProducers[i];
                NumericDocValues norms = null;
                if (normsProducer != null && (fieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.hasNorms()) {
                    norms = normsProducer.getNorms(fieldInfo);
                }
                if (norms == null) {
                    norms = DocValues.emptyNumeric();
                }
                toMerge.add(norms);
            }
            this.mergeNormsField(mergeFieldInfo, mergeState, toMerge);
        }
    }

    public void mergeNormsField(FieldInfo fieldInfo, final MergeState mergeState, final List<NumericDocValues> toMerge) throws IOException {
        this.addNormsField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<NumericDocValuesSub> subs = new ArrayList<NumericDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new NumericDocValuesSub(mergeState.docMaps[i], (NumericDocValues)toMerge.get(i), mergeState.maxDocs[i]));
                }
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                return new Iterator<Number>(){
                    long nextValue;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        NumericDocValuesSub sub = (NumericDocValuesSub)docIDMerger.next();
                        if (sub == null) {
                            return false;
                        }
                        this.nextIsSet = true;
                        this.nextValue = sub.values.get(sub.docID);
                        return true;
                    }
                };
            }
        });
    }

    private static class NumericDocValuesSub
    extends DocIDMerger.Sub {
        private final NumericDocValues values;
        private int docID = -1;
        private final int maxDoc;

        public NumericDocValuesSub(MergeState.DocMap docMap, NumericDocValues values, int maxDoc) {
            super(docMap);
            this.values = values;
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }
}

