/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;

final class SingletonSortedNumericDocValues
extends SortedNumericDocValues {
    private final NumericDocValues in;
    private final Bits docsWithField;
    private long value;
    private int count;

    public SingletonSortedNumericDocValues(NumericDocValues in, Bits docsWithField) {
        this.in = in;
        this.docsWithField = docsWithField instanceof Bits.MatchAllBits ? null : docsWithField;
    }

    public NumericDocValues getNumericDocValues() {
        return this.in;
    }

    public Bits getDocsWithField() {
        return this.docsWithField;
    }

    @Override
    public void setDocument(int doc) {
        this.value = this.in.get(doc);
        this.count = this.docsWithField != null && this.value == 0L && !this.docsWithField.get(doc) ? 0 : 1;
    }

    @Override
    public long valueAt(int index) {
        return this.value;
    }

    @Override
    public int count() {
        return this.count;
    }
}

