/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.AutomatonTermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SingleTermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValuesTermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.CompiledAutomaton;

public abstract class SortedDocValues
extends BinaryDocValues {
    private final BytesRef empty = new BytesRef();

    protected SortedDocValues() {
    }

    public abstract int getOrd(int var1);

    public abstract BytesRef lookupOrd(int var1);

    public abstract int getValueCount();

    @Override
    public BytesRef get(int docID) {
        int ord = this.getOrd(docID);
        if (ord == -1) {
            return this.empty;
        }
        return this.lookupOrd(ord);
    }

    public int lookupTerm(BytesRef key) {
        int low = 0;
        int high = this.getValueCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BytesRef term = this.lookupOrd(mid);
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public TermsEnum termsEnum() {
        return new SortedDocValuesTermsEnum(this);
    }

    public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
        TermsEnum in = this.termsEnum();
        switch (automaton.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return in;
            }
            case SINGLE: {
                return new SingleTermsEnum(in, automaton.term);
            }
            case NORMAL: {
                return new AutomatonTermsEnum(in, automaton);
            }
        }
        throw new RuntimeException("unhandled case");
    }
}

