/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

public final class MinDocQuery
extends Query {
    private final Object readerId;
    private final int minDoc;

    public MinDocQuery(int minDoc) {
        this(minDoc, null);
    }

    MinDocQuery(int minDoc, Object readerId) {
        this.minDoc = minDoc;
        this.readerId = readerId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.minDoc, this.readerId);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        MinDocQuery that = (MinDocQuery)obj;
        return this.minDoc == that.minDoc && Objects.equals(this.readerId, that.readerId);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (!Objects.equals(reader.getContext().id(), this.readerId)) {
            return new MinDocQuery(this.minDoc, reader.getContext().id());
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (this.readerId == null) {
            throw new IllegalStateException("Rewrite first");
        }
        if (!Objects.equals(searcher.getIndexReader().getContext().id(), this.readerId)) {
            throw new IllegalStateException("Executing against a different reader than the query has been rewritten against");
        }
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final int maxDoc = context.reader().maxDoc();
                if (context.docBase + maxDoc <= MinDocQuery.this.minDoc) {
                    return null;
                }
                final int segmentMinDoc = Math.max(0, MinDocQuery.this.minDoc - context.docBase);
                DocIdSetIterator disi = new DocIdSetIterator(){
                    int doc = -1;

                    @Override
                    public int docID() {
                        return this.doc;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        assert (target > this.doc);
                        this.doc = this.doc == -1 ? Math.max(target, segmentMinDoc) : target;
                        if (this.doc >= maxDoc) {
                            this.doc = Integer.MAX_VALUE;
                        }
                        return this.doc;
                    }

                    @Override
                    public long cost() {
                        return maxDoc - segmentMinDoc;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    @Override
    public String toString(String field) {
        return "MinDocQuery(minDoc=" + this.minDoc + ")";
    }
}

