/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ObjectIntHashMap;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.suggest.InputIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.suggest.Lookup;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.ByteArrayDataInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.ByteArrayDataOutput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.DataInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.InputStreamDataInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.OutputStreamDataOutput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.CharsRefBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IntsRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IntsRefBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.OfflineSorter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.LimitedFiniteStringsIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Operations;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Transition;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.fst.Builder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.fst.FST;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.fst.PairOutputs;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.fst.PositiveIntOutputs;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.fst.Util;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.SuppressForbidden;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.HppcMaps;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.PathUtils;

public class XAnalyzingSuggester
extends Lookup {
    private FST<PairOutputs.Pair<Long, BytesRef>> fst = null;
    private final Analyzer indexAnalyzer;
    private final Analyzer queryAnalyzer;
    private final boolean exactFirst;
    private final boolean preserveSep;
    public static final int EXACT_FIRST = 1;
    public static final int PRESERVE_SEP = 2;
    public static final int SEP_LABEL = 31;
    public static final int END_BYTE = 0;
    private final int maxSurfaceFormsPerAnalyzedForm;
    private final int maxGraphExpansions;
    private int maxAnalyzedPathsForOneInput;
    private boolean hasPayloads;
    private final int sepLabel;
    private final int payloadSep;
    private final int endByte;
    private final int holeCharacter;
    public static final int PAYLOAD_SEP = 31;
    public static final int HOLE_CHARACTER = 30;
    private final Automaton queryPrefix;
    private boolean preservePositionIncrements;
    private long count = 0L;
    private static FSDirectory tmpBuildDir;
    static final Comparator<PairOutputs.Pair<Long, BytesRef>> weightComparator;

    public XAnalyzingSuggester(Analyzer analyzer) {
        this(analyzer, null, analyzer, 3, 256, -1, true, null, false, 0, 31, 31, 0, 30);
    }

    public XAnalyzingSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, null, queryAnalyzer, 3, 256, -1, true, null, false, 0, 31, 31, 0, 30);
    }

    public XAnalyzingSuggester(Analyzer indexAnalyzer, Automaton queryPrefix, Analyzer queryAnalyzer, int options, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean preservePositionIncrements, FST<PairOutputs.Pair<Long, BytesRef>> fst, boolean hasPayloads, int maxAnalyzedPathsForOneInput, int sepLabel, int payloadSep, int endByte, int holeCharacter) {
        this.indexAnalyzer = indexAnalyzer;
        this.queryAnalyzer = queryAnalyzer;
        this.fst = fst;
        this.hasPayloads = hasPayloads;
        if ((options & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("options should only contain EXACT_FIRST and PRESERVE_SEP; got " + options);
        }
        this.exactFirst = (options & 1) != 0;
        this.preserveSep = (options & 2) != 0;
        this.queryPrefix = queryPrefix;
        if (maxSurfaceFormsPerAnalyzedForm <= 0 || maxSurfaceFormsPerAnalyzedForm > 256) {
            throw new IllegalArgumentException("maxSurfaceFormsPerAnalyzedForm must be > 0 and < 256 (got: " + maxSurfaceFormsPerAnalyzedForm + ")");
        }
        this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
        if (maxGraphExpansions < 1 && maxGraphExpansions != -1) {
            throw new IllegalArgumentException("maxGraphExpansions must -1 (no limit) or > 0 (got: " + maxGraphExpansions + ")");
        }
        this.maxGraphExpansions = maxGraphExpansions;
        this.maxAnalyzedPathsForOneInput = maxAnalyzedPathsForOneInput;
        this.preservePositionIncrements = preservePositionIncrements;
        this.sepLabel = sepLabel;
        this.payloadSep = payloadSep;
        this.endByte = endByte;
        this.holeCharacter = holeCharacter;
    }

    @Override
    public long ramBytesUsed() {
        return this.fst == null ? 0L : this.fst.ramBytesUsed();
    }

    public int getMaxAnalyzedPathsForOneInput() {
        return this.maxAnalyzedPathsForOneInput;
    }

    private Automaton replaceSep(Automaton a) {
        Automaton result = new Automaton();
        int numStates = a.getNumStates();
        for (int s = 0; s < numStates; ++s) {
            result.createState();
            result.setAccept(s, a.isAccept(s));
        }
        Transition t = new Transition();
        int[] topoSortStates = this.topoSortStates(a);
        for (int i = 0; i < topoSortStates.length; ++i) {
            int state = topoSortStates[topoSortStates.length - 1 - i];
            int count = a.initTransition(state, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                if (t.min == 31) {
                    assert (t.max == 31);
                    if (this.preserveSep) {
                        result.addTransition(state, t.dest, 31);
                        continue;
                    }
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                if (t.min == 30) {
                    assert (t.max == 30);
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                result.addTransition(state, t.dest, t.min, t.max);
            }
        }
        result.finishState();
        return result;
    }

    protected Automaton convertAutomaton(Automaton a) {
        if (this.queryPrefix != null) {
            a = Operations.concatenate(Arrays.asList(this.queryPrefix, a));
            a = Operations.determinize(a, Integer.MAX_VALUE);
        }
        return a;
    }

    private int[] topoSortStates(Automaton a) {
        int[] states = new int[a.getNumStates()];
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Integer> worklist = new LinkedList<Integer>();
        worklist.add(0);
        visited.add(0);
        int upto = 0;
        states[upto] = 0;
        ++upto;
        Transition t = new Transition();
        while (worklist.size() > 0) {
            int s = (Integer)worklist.removeFirst();
            int count = a.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (visited.contains(t.dest)) continue;
                visited.add(t.dest);
                worklist.add(t.dest);
                states[upto++] = t.dest;
            }
        }
        return states;
    }

    public TokenStreamToAutomaton getTokenStreamToAutomaton() {
        TokenStreamToAutomaton tsta = this.preserveSep ? new EscapingTokenStreamToAutomaton((char)this.sepLabel) : new TokenStreamToAutomaton();
        tsta.setPreservePositionIncrements(this.preservePositionIncrements);
        return tsta;
    }

    @SuppressForbidden(reason="access temp directory for building index")
    protected static synchronized FSDirectory getTempDir() {
        if (tmpBuildDir == null) {
            String tempDirPath = System.getProperty("java.io.tmpdir");
            if (tempDirPath == null) {
                throw new RuntimeException("Java has no temporary folder property (java.io.tmpdir)?");
            }
            try {
                tmpBuildDir = FSDirectory.open(PathUtils.get(tempDirPath, new String[0]));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return tmpBuildDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iterator) throws IOException {
        String prefix = this.getClass().getSimpleName();
        FSDirectory tempDir = XAnalyzingSuggester.getTempDir();
        OfflineSorter sorter = new OfflineSorter(tempDir, prefix, new AnalyzingComparator(this.hasPayloads));
        IndexOutput tempInput = ((Directory)tempDir).createTempOutput(prefix, "input", IOContext.DEFAULT);
        OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(tempInput);
        OfflineSorter.ByteSequencesReader reader = null;
        this.hasPayloads = iterator.hasPayloads();
        BytesRefBuilder scratch = new BytesRefBuilder();
        TokenStreamToAutomaton ts2a = this.getTokenStreamToAutomaton();
        String tempSortedFileName = null;
        this.count = 0L;
        byte[] buffer = new byte[8];
        try {
            BytesRef bytes;
            BytesRef surfaceForm;
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            while ((surfaceForm = iterator.next()) != null) {
                IntsRef string;
                LimitedFiniteStringsIterator finiteStrings = new LimitedFiniteStringsIterator(this.toAutomaton(surfaceForm, ts2a), this.maxGraphExpansions);
                while ((string = finiteStrings.next()) != null) {
                    BytesRef payload;
                    Util.toBytesRef(string, scratch);
                    if (scratch.length() > 32765) {
                        throw new IllegalArgumentException("cannot handle analyzed forms > 32765 in length (got " + scratch.length() + ")");
                    }
                    short analyzedLength = (short)scratch.length();
                    int requiredLength = analyzedLength + 4 + surfaceForm.length + 2;
                    if (this.hasPayloads) {
                        if (surfaceForm.length > 32765) {
                            throw new IllegalArgumentException("cannot handle surface form > 32765 in length (got " + surfaceForm.length + ")");
                        }
                        payload = iterator.payload();
                        requiredLength += payload.length + 2;
                    } else {
                        payload = null;
                    }
                    buffer = ArrayUtil.grow(buffer, requiredLength);
                    output.reset(buffer);
                    output.writeShort(analyzedLength);
                    output.writeBytes(scratch.bytes(), 0, scratch.length());
                    output.writeInt(XAnalyzingSuggester.encodeWeight(iterator.weight()));
                    if (this.hasPayloads) {
                        for (int i = 0; i < surfaceForm.length; ++i) {
                            if (surfaceForm.bytes[i] != this.payloadSep) continue;
                            throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
                        }
                        output.writeShort((short)surfaceForm.length);
                        output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                        output.writeBytes(payload.bytes, payload.offset, payload.length);
                    } else {
                        output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                    }
                    assert (output.getPosition() == requiredLength) : output.getPosition() + " vs " + requiredLength;
                    writer.write(buffer, 0, output.getPosition());
                    ++this.count;
                }
                this.maxAnalyzedPathsForOneInput = Math.max(this.maxAnalyzedPathsForOneInput, finiteStrings.size());
            }
            writer.close();
            tempSortedFileName = sorter.sort(tempInput.getName());
            ((Directory)tempDir).deleteFile(tempInput.getName());
            reader = new OfflineSorter.ByteSequencesReader(tempDir.openChecksumInput(tempSortedFileName, IOContext.READONCE), prefix);
            PairOutputs<Long, BytesRef> outputs = new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton());
            Builder<PairOutputs.Pair<Long, BytesRef>> builder = new Builder<PairOutputs.Pair<Long, BytesRef>>(FST.INPUT_TYPE.BYTE1, outputs);
            BytesRefBuilder previousAnalyzed = null;
            BytesRefBuilder analyzed = new BytesRefBuilder();
            BytesRef surface = new BytesRef();
            IntsRefBuilder scratchInts = new IntsRefBuilder();
            ByteArrayDataInput input = new ByteArrayDataInput();
            HashSet<BytesRef> seenSurfaceForms = new HashSet<BytesRef>();
            int dedup = 0;
            while ((bytes = reader.next()) != null) {
                input.reset(bytes.bytes, bytes.offset, bytes.length);
                short analyzedLength = input.readShort();
                analyzed.grow(analyzedLength + 2);
                input.readBytes(analyzed.bytes(), 0, analyzedLength);
                analyzed.setLength(analyzedLength);
                long cost = input.readInt();
                surface.bytes = bytes.bytes;
                if (this.hasPayloads) {
                    surface.length = input.readShort();
                    surface.offset = input.getPosition();
                } else {
                    surface.offset = input.getPosition();
                    surface.length = bytes.length - surface.offset;
                }
                if (previousAnalyzed == null) {
                    previousAnalyzed = new BytesRefBuilder();
                    previousAnalyzed.copyBytes(analyzed);
                    seenSurfaceForms.add(BytesRef.deepCopyOf(surface));
                } else if (analyzed.get().equals(previousAnalyzed.get())) {
                    if (++dedup >= this.maxSurfaceFormsPerAnalyzedForm || seenSurfaceForms.contains(surface)) continue;
                    seenSurfaceForms.add(BytesRef.deepCopyOf(surface));
                } else {
                    dedup = 0;
                    previousAnalyzed.copyBytes(analyzed);
                    seenSurfaceForms.clear();
                    seenSurfaceForms.add(BytesRef.deepCopyOf(surface));
                }
                analyzed.append((byte)0);
                analyzed.append((byte)dedup);
                Util.toIntsRef(analyzed.get(), scratchInts);
                if (!this.hasPayloads) {
                    builder.add(scratchInts.get(), outputs.newPair(cost, BytesRef.deepCopyOf(surface)));
                    continue;
                }
                int payloadOffset = input.getPosition() + surface.length;
                int payloadLength = bytes.length - payloadOffset;
                BytesRef br = new BytesRef(surface.length + 1 + payloadLength);
                System.arraycopy(surface.bytes, surface.offset, br.bytes, 0, surface.length);
                br.bytes[surface.length] = (byte)this.payloadSep;
                System.arraycopy(bytes.bytes, payloadOffset, br.bytes, surface.length + 1, payloadLength);
                br.length = br.bytes.length;
                builder.add(scratchInts.get(), outputs.newPair(cost, br));
            }
            this.fst = builder.finish();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(reader, writer);
            IOUtils.deleteFilesIgnoringExceptions((Directory)tempDir, tempInput.getName(), tempSortedFileName);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(reader, writer);
        IOUtils.deleteFilesIgnoringExceptions((Directory)tempDir, tempInput.getName(), tempSortedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(OutputStream output) throws IOException {
        OutputStreamDataOutput dataOut;
        block3: {
            boolean bl;
            dataOut = new OutputStreamDataOutput(output);
            try {
                if (this.fst != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(output);
                throw throwable;
            }
            IOUtils.close(output);
            return bl;
        }
        this.fst.save(dataOut);
        dataOut.writeVInt(this.maxAnalyzedPathsForOneInput);
        ((DataOutput)dataOut).writeByte((byte)(this.hasPayloads ? 1 : 0));
        IOUtils.close(output);
        return true;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public boolean load(InputStream input) throws IOException {
        InputStreamDataInput dataIn = new InputStreamDataInput(input);
        try {
            this.fst = new FST(dataIn, new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton()));
            this.maxAnalyzedPathsForOneInput = dataIn.readVInt();
            this.hasPayloads = ((DataInput)dataIn).readByte() == 1;
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close(input);
        return true;
    }

    private Lookup.LookupResult getLookupResult(Long output1, BytesRef output2, CharsRefBuilder spare) {
        Lookup.LookupResult result;
        if (this.hasPayloads) {
            int sepIndex = -1;
            for (int i = 0; i < output2.length; ++i) {
                if (output2.bytes[output2.offset + i] != this.payloadSep) continue;
                sepIndex = i;
                break;
            }
            assert (sepIndex != -1);
            int payloadLen = output2.length - sepIndex - 1;
            spare.copyUTF8Bytes(output2.bytes, output2.offset, sepIndex);
            BytesRef payload = new BytesRef(payloadLen);
            System.arraycopy(output2.bytes, sepIndex + 1, payload.bytes, 0, payloadLen);
            payload.length = payloadLen;
            result = new Lookup.LookupResult((CharSequence)spare.toString(), (long)XAnalyzingSuggester.decodeWeight(output1), payload);
        } else {
            spare.copyUTF8Bytes(output2);
            result = new Lookup.LookupResult(spare.toString(), XAnalyzingSuggester.decodeWeight(output1));
        }
        return result;
    }

    private boolean sameSurfaceForm(BytesRef key, BytesRef output2) {
        if (this.hasPayloads) {
            if (key.length >= output2.length) {
                return false;
            }
            for (int i = 0; i < key.length; ++i) {
                if (key.bytes[key.offset + i] == output2.bytes[output2.offset + i]) continue;
                return false;
            }
            return output2.bytes[output2.offset + key.length] == this.payloadSep;
        }
        return key.bytesEquals(output2);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == this.holeCharacter) {
                throw new IllegalArgumentException("lookup key cannot contain HOLE character U+001E; this character is reserved");
            }
            if (key.charAt(i) != this.sepLabel) continue;
            throw new IllegalArgumentException("lookup key cannot contain unit separator character U+001F; this character is reserved");
        }
        final BytesRef utf8Key = new BytesRef(key);
        try {
            Automaton lookupAutomaton = this.toLookupAutomaton(key);
            CharsRefBuilder spare = new CharsRefBuilder();
            FST.BytesReader bytesReader = this.fst.getBytesReader();
            FST.Arc scratchArc = new FST.Arc();
            final ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
            List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths = FSTUtil.intersectPrefixPaths(this.convertAutomaton(lookupAutomaton), this.fst);
            if (this.exactFirst) {
                int count = 0;
                for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                    if (this.fst.findTargetArc(this.endByte, path.fstNode, scratchArc, bytesReader) == null) continue;
                    ++count;
                }
                Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, count * this.maxSurfaceFormsPerAnalyzedForm, count * this.maxSurfaceFormsPerAnalyzedForm, weightComparator);
                for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                    if (this.fst.findTargetArc(this.endByte, path.fstNode, scratchArc, bytesReader) == null) continue;
                    searcher.addStartPaths(scratchArc, (PairOutputs.Pair<Long, BytesRef>)this.fst.outputs.add(path.output, scratchArc.output), false, path.input);
                }
                Util.TopResults topResults = searcher.search();
                for (Util.Result result : topResults) {
                    BytesRef output2 = (BytesRef)((PairOutputs.Pair)result.output).output2;
                    if (!this.sameSurfaceForm(utf8Key, output2)) continue;
                    results.add(this.getLookupResult((Long)((PairOutputs.Pair)result.output).output1, output2, spare));
                    break;
                }
                if (results.size() == num) {
                    return results;
                }
            }
            Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, num - results.size(), num * this.maxAnalyzedPathsForOneInput, weightComparator){
                private final Set<BytesRef> seen;
                {
                    super(x0, x1, x2, x3);
                    this.seen = new HashSet<BytesRef>();
                }

                @Override
                protected boolean acceptResult(IntsRef input, PairOutputs.Pair<Long, BytesRef> output) {
                    if (this.seen.contains(output.output2)) {
                        return false;
                    }
                    this.seen.add((BytesRef)output.output2);
                    if (!XAnalyzingSuggester.this.exactFirst) {
                        return true;
                    }
                    if (XAnalyzingSuggester.this.sameSurfaceForm(utf8Key, (BytesRef)output.output2)) {
                        assert (results.size() == 1);
                        return false;
                    }
                    return true;
                }
            };
            prefixPaths = this.getFullPrefixPaths(prefixPaths, lookupAutomaton, this.fst);
            for (FSTUtil.Path path : prefixPaths) {
                searcher.addStartPaths(path.fstNode, (PairOutputs.Pair<Long, BytesRef>)path.output, true, path.input);
            }
            Util.TopResults completions = searcher.search();
            for (Util.Result result : completions) {
                Lookup.LookupResult lookupResult = this.getLookupResult((Long)((PairOutputs.Pair)result.output).output1, (BytesRef)((PairOutputs.Pair)result.output).output2, spare);
                results.add(lookupResult);
                if (results.size() != num) continue;
                break;
            }
            return results;
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    @Override
    public boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.fst == null) {
            return false;
        }
        this.fst.save(output);
        output.writeVInt(this.maxAnalyzedPathsForOneInput);
        output.writeByte((byte)(this.hasPayloads ? 1 : 0));
        return true;
    }

    @Override
    public boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.fst = new FST(input, new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton()));
        this.maxAnalyzedPathsForOneInput = input.readVInt();
        this.hasPayloads = input.readByte() == 1;
        return true;
    }

    protected List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> getFullPrefixPaths(List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths, Automaton lookupAutomaton, FST<PairOutputs.Pair<Long, BytesRef>> fst) throws IOException {
        return prefixPaths;
    }

    final Automaton toAutomaton(BytesRef surfaceForm, TokenStreamToAutomaton ts2a) throws IOException {
        try (TokenStream ts = this.indexAnalyzer.tokenStream("", surfaceForm.utf8ToString());){
            Automaton automaton = this.toAutomaton(ts, ts2a);
            return automaton;
        }
    }

    final Automaton toAutomaton(TokenStream ts, TokenStreamToAutomaton ts2a) throws IOException {
        Automaton automaton = ts2a.toAutomaton(ts);
        automaton = this.replaceSep(automaton);
        automaton = this.convertAutomaton(automaton);
        return automaton;
    }

    public Set<IntsRef> toFiniteStrings(TokenStream stream) throws IOException {
        Automaton automaton;
        TokenStreamToAutomaton ts2a = this.getTokenStreamToAutomaton();
        try (TokenStream ts = stream;){
            automaton = this.toAutomaton(ts, ts2a);
        }
        LimitedFiniteStringsIterator finiteStrings = new LimitedFiniteStringsIterator(automaton, this.maxGraphExpansions);
        HashSet<IntsRef> set = new HashSet<IntsRef>();
        IntsRef string = finiteStrings.next();
        while (string != null) {
            set.add(IntsRef.deepCopyOf(string));
            string = finiteStrings.next();
        }
        return Collections.unmodifiableSet(set);
    }

    final Automaton toLookupAutomaton(CharSequence key) throws IOException {
        Automaton automaton = null;
        try (TokenStream ts = this.queryAnalyzer.tokenStream("", key.toString());){
            automaton = this.getTokenStreamToAutomaton().toAutomaton(ts);
        }
        automaton = this.replaceSep(automaton);
        automaton = Operations.determinize(automaton, Integer.MAX_VALUE);
        return automaton;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }

    public static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    public static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    static {
        weightComparator = new Comparator<PairOutputs.Pair<Long, BytesRef>>(){

            @Override
            public int compare(PairOutputs.Pair<Long, BytesRef> left, PairOutputs.Pair<Long, BytesRef> right) {
                return ((Long)left.output1).compareTo((Long)right.output1);
            }
        };
    }

    public static class XBuilder {
        private Builder<PairOutputs.Pair<Long, BytesRef>> builder;
        private int maxSurfaceFormsPerAnalyzedForm;
        private IntsRefBuilder scratchInts = new IntsRefBuilder();
        private final PairOutputs<Long, BytesRef> outputs;
        private boolean hasPayloads;
        private BytesRefBuilder analyzed = new BytesRefBuilder();
        private final SurfaceFormAndPayload[] surfaceFormsAndPayload;
        private int count;
        private ObjectIntHashMap<BytesRef> seenSurfaceForms = HppcMaps.Object.Integer.ensureNoNullKeys(256, 0.75f);
        private int payloadSep;

        public XBuilder(int maxSurfaceFormsPerAnalyzedForm, boolean hasPayloads, int payloadSep) {
            this.payloadSep = payloadSep;
            this.outputs = new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton());
            this.builder = new Builder(FST.INPUT_TYPE.BYTE1, this.outputs);
            this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
            this.hasPayloads = hasPayloads;
            this.surfaceFormsAndPayload = new SurfaceFormAndPayload[maxSurfaceFormsPerAnalyzedForm];
        }

        public void startTerm(BytesRef analyzed) {
            this.analyzed.grow(analyzed.length + 2);
            this.analyzed.copyBytes(analyzed);
        }

        public void addSurface(BytesRef surface, BytesRef payload, long cost) throws IOException {
            BytesRef payloadRef;
            BytesRef surfaceCopy;
            int keySlot;
            long encodedWeight;
            int surfaceIndex = -1;
            long l = encodedWeight = cost == -1L ? cost : (long)XAnalyzingSuggester.encodeWeight(cost);
            if (this.count >= this.maxSurfaceFormsPerAnalyzedForm) {
                return;
            }
            if (this.count > 0 && (keySlot = this.seenSurfaceForms.indexOf(surface)) >= 0) {
                surfaceIndex = this.seenSurfaceForms.indexGet(keySlot);
                SurfaceFormAndPayload surfaceFormAndPayload = this.surfaceFormsAndPayload[surfaceIndex];
                if (encodedWeight >= surfaceFormAndPayload.weight) {
                    return;
                }
                surfaceCopy = BytesRef.deepCopyOf(surface);
            } else {
                surfaceIndex = this.count++;
                surfaceCopy = BytesRef.deepCopyOf(surface);
                this.seenSurfaceForms.put(surfaceCopy, surfaceIndex);
            }
            if (!this.hasPayloads) {
                payloadRef = surfaceCopy;
            } else {
                int len = surface.length + 1 + payload.length;
                BytesRef br = new BytesRef(len);
                System.arraycopy(surface.bytes, surface.offset, br.bytes, 0, surface.length);
                br.bytes[surface.length] = (byte)this.payloadSep;
                System.arraycopy(payload.bytes, payload.offset, br.bytes, surface.length + 1, payload.length);
                br.length = len;
                payloadRef = br;
            }
            if (this.surfaceFormsAndPayload[surfaceIndex] == null) {
                this.surfaceFormsAndPayload[surfaceIndex] = new SurfaceFormAndPayload(payloadRef, encodedWeight);
            } else {
                this.surfaceFormsAndPayload[surfaceIndex].payload = payloadRef;
                this.surfaceFormsAndPayload[surfaceIndex].weight = encodedWeight;
            }
        }

        public void finishTerm(long defaultWeight) throws IOException {
            ArrayUtil.timSort((Comparable[])this.surfaceFormsAndPayload, (int)0, (int)this.count);
            int deduplicator = 0;
            this.analyzed.append((byte)0);
            this.analyzed.setLength(this.analyzed.length() + 1);
            this.analyzed.grow(this.analyzed.length());
            for (int i = 0; i < this.count; ++i) {
                this.analyzed.setByteAt(this.analyzed.length() - 1, (byte)deduplicator++);
                Util.toIntsRef(this.analyzed.get(), this.scratchInts);
                SurfaceFormAndPayload candiate = this.surfaceFormsAndPayload[i];
                long cost = candiate.weight == -1L ? (long)XAnalyzingSuggester.encodeWeight(Math.min(Integer.MAX_VALUE, defaultWeight)) : candiate.weight;
                this.builder.add(this.scratchInts.get(), this.outputs.newPair(cost, candiate.payload));
            }
            this.seenSurfaceForms.clear();
            this.count = 0;
        }

        public FST<PairOutputs.Pair<Long, BytesRef>> build() throws IOException {
            return this.builder.finish();
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        public int maxSurfaceFormsPerAnalyzedForm() {
            return this.maxSurfaceFormsPerAnalyzedForm;
        }

        private static final class SurfaceFormAndPayload
        implements Comparable<SurfaceFormAndPayload> {
            BytesRef payload;
            long weight;

            SurfaceFormAndPayload(BytesRef payload, long cost) {
                this.payload = payload;
                this.weight = cost;
            }

            @Override
            public int compareTo(SurfaceFormAndPayload o) {
                int res = SurfaceFormAndPayload.compare(this.weight, o.weight);
                if (res == 0) {
                    return this.payload.compareTo(o.payload);
                }
                return res;
            }

            public static int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        }
    }

    private static class AnalyzingComparator
    implements Comparator<BytesRef> {
        private final boolean hasPayloads;
        private final ByteArrayDataInput readerA = new ByteArrayDataInput();
        private final ByteArrayDataInput readerB = new ByteArrayDataInput();
        private final BytesRef scratchA = new BytesRef();
        private final BytesRef scratchB = new BytesRef();

        AnalyzingComparator(boolean hasPayloads) {
            this.hasPayloads = hasPayloads;
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            this.readerA.reset(a.bytes, a.offset, a.length);
            this.scratchA.length = this.readerA.readShort();
            this.scratchA.bytes = a.bytes;
            this.scratchA.offset = this.readerA.getPosition();
            this.readerB.reset(b.bytes, b.offset, b.length);
            this.scratchB.bytes = b.bytes;
            this.scratchB.length = this.readerB.readShort();
            this.scratchB.offset = this.readerB.getPosition();
            int cmp = this.scratchA.compareTo(this.scratchB);
            if (cmp != 0) {
                return cmp;
            }
            this.readerA.skipBytes(this.scratchA.length);
            this.readerB.skipBytes(this.scratchB.length);
            long aCost = this.readerA.readInt();
            long bCost = this.readerB.readInt();
            if (aCost < bCost) {
                return -1;
            }
            if (aCost > bCost) {
                return 1;
            }
            if (this.hasPayloads) {
                this.scratchA.length = this.readerA.readShort();
                this.scratchA.offset = this.readerA.getPosition();
                this.scratchB.length = this.readerB.readShort();
                this.scratchB.offset = this.readerB.getPosition();
            } else {
                this.scratchA.offset = this.readerA.getPosition();
                this.scratchA.length = a.length - this.scratchA.offset;
                this.scratchB.offset = this.readerB.getPosition();
                this.scratchB.length = b.length - this.scratchB.offset;
            }
            return this.scratchA.compareTo(this.scratchB);
        }
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRefBuilder spare = new BytesRefBuilder();
        private char sepLabel;

        EscapingTokenStreamToAutomaton(char sepLabel) {
            this.sepLabel = sepLabel;
        }

        @Override
        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == (byte)this.sepLabel) {
                    this.spare.grow(upto + 2);
                    this.spare.setByteAt(upto++, (byte)this.sepLabel);
                    this.spare.setByteAt(upto++, b);
                    continue;
                }
                this.spare.grow(upto + 1);
                this.spare.setByteAt(upto++, b);
            }
            this.spare.setLength(upto);
            return this.spare.get();
        }
    }
}

