/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.CachingTokenFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MultiPhraseQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.PhraseQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SynonymQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanNearQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanOrQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanTermQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;

public class QueryBuilder {
    protected Analyzer analyzer;
    protected boolean enablePositionIncrements = true;
    protected boolean enableGraphQueries = true;
    protected boolean autoGenerateMultiTermSynonymsPhraseQuery = false;

    public QueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Query createBooleanQuery(String field, String queryText) {
        return this.createBooleanQuery(field, queryText, BooleanClause.Occur.SHOULD);
    }

    public Query createBooleanQuery(String field, String queryText, BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        return this.createFieldQuery(this.analyzer, operator, field, queryText, false, 0);
    }

    public Query createPhraseQuery(String field, String queryText) {
        return this.createPhraseQuery(field, queryText, 0);
    }

    public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
        return this.createFieldQuery(this.analyzer, BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
    }

    public Query createMinShouldMatchQuery(String field, String queryText, float fraction) {
        if (Float.isNaN(fraction) || fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("fraction should be >= 0 and <= 1");
        }
        if (fraction == 1.0f) {
            return this.createBooleanQuery(field, queryText, BooleanClause.Occur.MUST);
        }
        Query query = this.createFieldQuery(this.analyzer, BooleanClause.Occur.SHOULD, field, queryText, false, 0);
        if (query instanceof BooleanQuery) {
            query = this.addMinShouldMatchToBoolean((BooleanQuery)query, fraction);
        }
        return query;
    }

    private BooleanQuery addMinShouldMatchToBoolean(BooleanQuery query, float fraction) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(query.isCoordDisabled());
        builder.setMinimumNumberShouldMatch((int)(fraction * (float)query.clauses().size()));
        for (BooleanClause clause : query) {
            builder.add(clause);
        }
        return builder.build();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }

    public boolean getAutoGenerateMultiTermSynonymsPhraseQuery() {
        return this.autoGenerateMultiTermSynonymsPhraseQuery;
    }

    public void setAutoGenerateMultiTermSynonymsPhraseQuery(boolean enable) {
        this.autoGenerateMultiTermSynonymsPhraseQuery = enable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
        assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
        try (TokenStream source = analyzer.tokenStream(field, queryText);){
            Query query = this.createFieldQuery(source, operator, field, quoted, phraseSlop);
            return query;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    public void setEnableGraphQueries(boolean v) {
        this.enableGraphQueries = v;
    }

    public boolean getEnableGraphQueries() {
        return this.enableGraphQueries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query createFieldQuery(TokenStream source, BooleanClause.Occur operator, String field, boolean quoted, int phraseSlop) {
        assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
        try (CachingTokenFilter stream = new CachingTokenFilter(source);){
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncAtt = stream.addAttribute(PositionIncrementAttribute.class);
            PositionLengthAttribute posLenAtt = stream.addAttribute(PositionLengthAttribute.class);
            if (termAtt == null) {
                Query query = null;
                return query;
            }
            int numTokens = 0;
            int positionCount = 0;
            boolean hasSynonyms = false;
            boolean isGraph = false;
            stream.reset();
            while (stream.incrementToken()) {
                ++numTokens;
                int positionIncrement = posIncAtt.getPositionIncrement();
                if (positionIncrement != 0) {
                    positionCount += positionIncrement;
                } else {
                    hasSynonyms = true;
                }
                int positionLength = posLenAtt.getPositionLength();
                if (!this.enableGraphQueries || positionLength <= 1) continue;
                isGraph = true;
            }
            if (numTokens == 0) {
                Query query = null;
                return query;
            }
            if (numTokens == 1) {
                Query query = this.analyzeTerm(field, stream);
                return query;
            }
            if (isGraph) {
                if (quoted) {
                    SpanQuery spanQuery = this.analyzeGraphPhrase(stream, field, phraseSlop);
                    return spanQuery;
                }
                Query query = this.analyzeGraphBoolean(field, stream, operator);
                return query;
            }
            if (quoted && positionCount > 1) {
                if (hasSynonyms) {
                    Query query = this.analyzeMultiPhrase(field, stream, phraseSlop);
                    return query;
                }
                Query query = this.analyzePhrase(field, stream, phraseSlop);
                return query;
            }
            if (positionCount == 1) {
                Query query = this.analyzeBoolean(field, stream);
                return query;
            }
            Query query = this.analyzeMultiBoolean(field, stream, operator);
            return query;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    protected final SpanQuery createSpanQuery(TokenStream in, String field) throws IOException {
        TermToBytesRefAttribute termAtt = in.getAttribute(TermToBytesRefAttribute.class);
        if (termAtt == null) {
            return null;
        }
        ArrayList<SpanTermQuery> terms = new ArrayList<SpanTermQuery>();
        while (in.incrementToken()) {
            terms.add(new SpanTermQuery(new Term(field, termAtt.getBytesRef())));
        }
        if (terms.isEmpty()) {
            return null;
        }
        if (terms.size() == 1) {
            return (SpanQuery)terms.get(0);
        }
        return new SpanNearQuery(terms.toArray(new SpanTermQuery[0]), 0, true);
    }

    protected Query analyzeTerm(String field, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        stream.reset();
        if (!stream.incrementToken()) {
            throw new AssertionError();
        }
        return this.newTermQuery(new Term(field, termAtt.getBytesRef()));
    }

    protected Query analyzeBoolean(String field, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        stream.reset();
        ArrayList<Term> terms = new ArrayList<Term>();
        while (stream.incrementToken()) {
            terms.add(new Term(field, termAtt.getBytesRef()));
        }
        return this.newSynonymQuery(terms.toArray(new Term[terms.size()]));
    }

    protected void add(BooleanQuery.Builder q, List<Term> current, BooleanClause.Occur operator) {
        if (current.isEmpty()) {
            return;
        }
        if (current.size() == 1) {
            q.add(this.newTermQuery(current.get(0)), operator);
        } else {
            q.add(this.newSynonymQuery(current.toArray(new Term[current.size()])), operator);
        }
    }

    protected Query analyzeMultiBoolean(String field, TokenStream stream, BooleanClause.Occur operator) throws IOException {
        BooleanQuery.Builder q = this.newBooleanQuery();
        ArrayList<Term> currentQuery = new ArrayList<Term>();
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                this.add(q, currentQuery, operator);
                currentQuery.clear();
            }
            currentQuery.add(new Term(field, termAtt.getBytesRef()));
        }
        this.add(q, currentQuery, operator);
        return q.build();
    }

    protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        stream.reset();
        while (stream.incrementToken()) {
            position = this.enablePositionIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
            builder.add(new Term(field, termAtt.getBytesRef()), position);
        }
        return builder.build();
    }

    protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
        MultiPhraseQuery.Builder mpqb = this.newMultiPhraseQueryBuilder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (this.enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (this.enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    protected Query analyzeGraphBoolean(final String field, TokenStream source, BooleanClause.Occur operator) throws IOException {
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        int[] articulationPoints = graph.articulationPoints();
        int lastState = 0;
        for (int i = 0; i <= articulationPoints.length; ++i) {
            Query queryPos;
            int start = lastState;
            int end = -1;
            if (i < articulationPoints.length) {
                end = articulationPoints[i];
            }
            lastState = end;
            if (graph.hasSidePath(start)) {
                final Iterator<TokenStream> it = graph.getFiniteStrings(start, end);
                Iterator<Query> queries = new Iterator<Query>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Query next() {
                        TokenStream ts = (TokenStream)it.next();
                        return QueryBuilder.this.createFieldQuery(ts, BooleanClause.Occur.MUST, field, QueryBuilder.this.getAutoGenerateMultiTermSynonymsPhraseQuery(), 0);
                    }
                };
                queryPos = this.newGraphSynonymQuery(queries);
            } else {
                Term[] terms = graph.getTerms(field, start);
                assert (terms.length > 0);
                queryPos = terms.length == 1 ? this.newTermQuery(terms[0]) : this.newSynonymQuery(terms);
            }
            if (queryPos == null) continue;
            builder.add(queryPos, operator);
        }
        return builder.build();
    }

    protected SpanQuery analyzeGraphPhrase(TokenStream source, String field, int phraseSlop) throws IOException {
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        ArrayList<SpanTermQuery> clauses = new ArrayList<SpanTermQuery>();
        int[] articulationPoints = graph.articulationPoints();
        int lastState = 0;
        for (int i = 0; i <= articulationPoints.length; ++i) {
            SpanQuery queryPos;
            int start = lastState;
            int end = -1;
            if (i < articulationPoints.length) {
                end = articulationPoints[i];
            }
            lastState = end;
            if (graph.hasSidePath(start)) {
                ArrayList<SpanQuery> queries = new ArrayList<SpanQuery>();
                Iterator<TokenStream> it = graph.getFiniteStrings(start, end);
                while (it.hasNext()) {
                    TokenStream ts = it.next();
                    SpanQuery q = this.createSpanQuery(ts, field);
                    if (q == null) continue;
                    queries.add(q);
                }
                queryPos = queries.size() > 0 ? new SpanOrQuery(queries.toArray(new SpanQuery[0])) : null;
            } else {
                Term[] terms = graph.getTerms(field, start);
                assert (terms.length > 0);
                if (terms.length == 1) {
                    queryPos = new SpanTermQuery(terms[0]);
                } else {
                    SpanQuery[] orClauses = new SpanTermQuery[terms.length];
                    for (int idx = 0; idx < terms.length; ++idx) {
                        orClauses[idx] = new SpanTermQuery(terms[idx]);
                    }
                    queryPos = new SpanOrQuery(orClauses);
                }
            }
            if (queryPos == null) continue;
            clauses.add((SpanTermQuery)queryPos);
        }
        if (clauses.isEmpty()) {
            return null;
        }
        if (clauses.size() == 1) {
            return (SpanQuery)clauses.get(0);
        }
        return new SpanNearQuery(clauses.toArray(new SpanQuery[0]), phraseSlop, true);
    }

    protected BooleanQuery.Builder newBooleanQuery() {
        return new BooleanQuery.Builder();
    }

    protected Query newSynonymQuery(Term[] terms) {
        return new SynonymQuery(terms);
    }

    protected Query newGraphSynonymQuery(Iterator<Query> queries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        while (queries.hasNext()) {
            builder.add(queries.next(), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery bq = builder.build();
        if (bq.clauses().size() == 1) {
            return bq.clauses().get(0).getQuery();
        }
        return bq;
    }

    protected Query newTermQuery(Term term) {
        return new TermQuery(term);
    }

    protected MultiPhraseQuery.Builder newMultiPhraseQueryBuilder() {
        return new MultiPhraseQuery.Builder();
    }
}

