/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchTimeoutException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionFuture;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.BaseFuture;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    @Override
    public T actionGet() {
        try {
            return (T)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            throw AdapterActionFuture.rethrowExecutionException(e);
        }
    }

    @Override
    public T actionGet(String timeout) {
        return this.actionGet(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".actionGet.timeout"));
    }

    @Override
    public T actionGet(long timeoutMillis) {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout) {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) {
        try {
            return (T)this.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ElasticsearchTimeoutException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            throw AdapterActionFuture.rethrowExecutionException(e);
        }
    }

    static RuntimeException rethrowExecutionException(ExecutionException e) {
        if (e.getCause() instanceof ElasticsearchException) {
            ElasticsearchException esEx = (ElasticsearchException)e.getCause();
            Throwable root = esEx.unwrapCause();
            if (root instanceof ElasticsearchException) {
                return (ElasticsearchException)root;
            }
            if (root instanceof RuntimeException) {
                return (RuntimeException)root;
            }
            return new UncategorizedExecutionException("Failed execution", root);
        }
        if (e.getCause() instanceof RuntimeException) {
            return (RuntimeException)e.getCause();
        }
        return new UncategorizedExecutionException("Failed execution", e);
    }

    @Override
    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    @Override
    public void onFailure(Exception e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);
}

