/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Booleans;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;

final class AutoExpandReplicas {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(AutoExpandReplicas.class));
    private static final String ALL_NODES_VALUE = "all";
    public static final Setting<AutoExpandReplicas> SETTING = new Setting<AutoExpandReplicas>("index.auto_expand_replicas", "false", value -> {
        int max;
        int min;
        if (Booleans.isExplicitFalse(value)) {
            if (!Booleans.isStrictlyBoolean(value)) {
                DEPRECATION_LOGGER.deprecated("Expected [false] for setting [{}] but got [{}]", "index.auto_expand_replicas", value);
            }
            return new AutoExpandReplicas(0, 0, false);
        }
        int dash = value.indexOf(45);
        if (-1 == dash) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash);
        }
        String sMin = value.substring(0, dash);
        try {
            min = Integer.parseInt(sMin);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
        }
        String sMax = value.substring(dash + 1);
        if (sMax.equals(ALL_NODES_VALUE)) {
            max = Integer.MAX_VALUE;
        } else {
            try {
                max = Integer.parseInt(sMax);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
            }
        }
        return new AutoExpandReplicas(min, max, true);
    }, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final int minReplicas;
    private final int maxReplicas;
    private final boolean enabled;

    private AutoExpandReplicas(int minReplicas, int maxReplicas, boolean enabled) {
        if (minReplicas > maxReplicas) {
            throw new IllegalArgumentException("[index.auto_expand_replicas] minReplicas must be =< maxReplicas but wasn't " + minReplicas + " > " + maxReplicas);
        }
        this.minReplicas = minReplicas;
        this.maxReplicas = maxReplicas;
        this.enabled = enabled;
    }

    int getMinReplicas() {
        return this.minReplicas;
    }

    int getMaxReplicas(int numDataNodes) {
        return Math.min(this.maxReplicas, numDataNodes - 1);
    }

    public String toString() {
        return this.enabled ? this.minReplicas + "-" + this.maxReplicas : "false";
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

