/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;

public class FailedShard {
    private final ShardRouting routingEntry;
    private final String message;
    private final Exception failure;

    public FailedShard(ShardRouting routingEntry, String message, Exception failure) {
        assert (routingEntry.assignedToNode()) : "only assigned shards can be failed " + routingEntry;
        this.routingEntry = routingEntry;
        this.message = message;
        this.failure = failure;
    }

    public String toString() {
        return "failed shard, shard " + this.routingEntry + ", message [" + this.message + "], failure [" + ExceptionsHelper.detailedMessage(this.failure) + "]";
    }

    public ShardRouting getRoutingEntry() {
        return this.routingEntry;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }
}

