/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Key;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.InjectionPoint;

public final class Dependency<T> {
    private final InjectionPoint injectionPoint;
    private final Key<T> key;
    private final boolean nullable;
    private final int parameterIndex;

    Dependency(InjectionPoint injectionPoint, Key<T> key, boolean nullable, int parameterIndex) {
        this.injectionPoint = injectionPoint;
        this.key = key;
        this.nullable = nullable;
        this.parameterIndex = parameterIndex;
    }

    public static <T> Dependency<T> get(Key<T> key) {
        return new Dependency<T>(null, key, true, -1);
    }

    public static Set<Dependency<?>> forInjectionPoints(Set<InjectionPoint> injectionPoints) {
        HashSet dependencies = new HashSet();
        for (InjectionPoint injectionPoint : injectionPoints) {
            dependencies.addAll(injectionPoint.getDependencies());
        }
        return Collections.unmodifiableSet(dependencies);
    }

    public Key<T> getKey() {
        return this.key;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public int hashCode() {
        return Objects.hash(this.injectionPoint, this.parameterIndex, this.key);
    }

    public boolean equals(Object o) {
        if (o instanceof Dependency) {
            Dependency dependency = (Dependency)o;
            return Objects.equals(this.injectionPoint, dependency.injectionPoint) && Objects.equals(this.parameterIndex, dependency.parameterIndex) && Objects.equals(this.key, dependency.key);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.key);
        if (this.injectionPoint != null) {
            builder.append("@").append(this.injectionPoint);
            if (this.parameterIndex != -1) {
                builder.append("[").append(this.parameterIndex).append("]");
            }
        }
        return builder.toString();
    }
}

