/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.metrics.CounterMetric;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsAbortPolicy
implements XRejectedExecutionHandler {
    private final CounterMetric rejected = new CounterMetric();

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (r instanceof AbstractRunnable && ((AbstractRunnable)r).isForceExecution()) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            if (!(queue instanceof SizeBlockingQueue)) {
                throw new IllegalStateException("forced execution, but expected a size queue");
            }
            try {
                ((SizeBlockingQueue)queue).forcePut(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("forced execution, but got interrupted", e);
            }
            return;
        }
        this.rejected.inc();
        throw new EsRejectedExecutionException("rejected execution of " + r + " on " + executor, executor.isShutdown());
    }

    @Override
    public long rejected() {
        return this.rejected.count();
    }
}

