/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.CloseableThreadLocal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.ESLoggerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AbstractRunnable;

public final class ThreadContext
implements Closeable,
Writeable {
    public static final String PREFIX = "request.headers";
    public static final Setting<Settings> DEFAULT_HEADERS_SETTING = Setting.groupSetting("request.headers.", Setting.Property.NodeScope);
    private static final ThreadContextStruct DEFAULT_CONTEXT = new ThreadContextStruct();
    private final Map<String, String> defaultHeader;
    private final ContextThreadLocal threadLocal;
    private boolean isSystemContext;

    public ThreadContext(Settings settings) {
        Settings headers = DEFAULT_HEADERS_SETTING.get(settings);
        if (headers == null) {
            this.defaultHeader = Collections.emptyMap();
        } else {
            HashMap<String, String> defaultHeader = new HashMap<String, String>();
            for (String key : headers.names()) {
                defaultHeader.put(key, headers.get(key));
            }
            this.defaultHeader = Collections.unmodifiableMap(defaultHeader);
        }
        this.threadLocal = new ContextThreadLocal();
    }

    @Override
    public void close() throws IOException {
        this.threadLocal.close();
    }

    public StoredContext stashContext() {
        ThreadContextStruct context = this.threadLocal.get();
        this.threadLocal.set(null);
        return () -> this.threadLocal.set(context);
    }

    public StoredContext stashAndMergeHeaders(Map<String, String> headers) {
        ThreadContextStruct context = this.threadLocal.get();
        HashMap<String, String> newHeader = new HashMap<String, String>(headers);
        newHeader.putAll(context.requestHeaders);
        this.threadLocal.set(ThreadContext.DEFAULT_CONTEXT.putHeaders(newHeader));
        return () -> this.threadLocal.set(context);
    }

    public StoredContext newStoredContext(boolean preserveResponseHeaders) {
        ThreadContextStruct context = this.threadLocal.get();
        return () -> {
            if (preserveResponseHeaders && this.threadLocal.get() != context) {
                this.threadLocal.set(context.putResponseHeaders(this.threadLocal.get().responseHeaders));
            } else {
                this.threadLocal.set(context);
            }
        };
    }

    public Supplier<StoredContext> newRestorableContext(boolean preserveResponseHeaders) {
        return this.wrapRestorable(this.newStoredContext(preserveResponseHeaders));
    }

    public Supplier<StoredContext> wrapRestorable(StoredContext storedContext) {
        return () -> {
            StoredContext context = this.newStoredContext(false);
            storedContext.restore();
            return context;
        };
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.threadLocal.get().writeTo(out, this.defaultHeader);
    }

    public void readHeaders(StreamInput in) throws IOException {
        this.threadLocal.set(new ThreadContextStruct(in));
    }

    public String getHeader(String key) {
        String value = (String)this.threadLocal.get().requestHeaders.get(key);
        if (value == null) {
            return this.defaultHeader.get(key);
        }
        return value;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>(this.defaultHeader);
        map.putAll(this.threadLocal.get().requestHeaders);
        return Collections.unmodifiableMap(map);
    }

    public Map<String, List<String>> getResponseHeaders() {
        Map responseHeaders = this.threadLocal.get().responseHeaders;
        HashMap map = new HashMap(responseHeaders.size());
        for (Map.Entry entry : responseHeaders.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public void copyHeaders(Iterable<Map.Entry<String, String>> headers) {
        this.threadLocal.set(this.threadLocal.get().copyHeaders(headers));
    }

    public void putHeader(String key, String value) {
        this.threadLocal.set(this.threadLocal.get().putRequest(key, value));
    }

    public void putHeader(Map<String, String> header) {
        this.threadLocal.set(this.threadLocal.get().putHeaders(header));
    }

    public void putTransient(String key, Object value) {
        this.threadLocal.set(this.threadLocal.get().putTransient(key, value));
    }

    public <T> T getTransient(String key) {
        return (T)this.threadLocal.get().transientHeaders.get(key);
    }

    public void addResponseHeader(String key, String value) {
        this.addResponseHeader(key, value, v -> v);
    }

    public void addResponseHeader(String key, String value, Function<String, String> uniqueValue) {
        this.threadLocal.set(this.threadLocal.get().putResponse(key, value, uniqueValue));
    }

    public Runnable preserveContext(Runnable command) {
        if (command instanceof ContextPreservingAbstractRunnable) {
            return command;
        }
        if (command instanceof ContextPreservingRunnable) {
            return command;
        }
        if (command instanceof AbstractRunnable) {
            return new ContextPreservingAbstractRunnable((AbstractRunnable)command);
        }
        return new ContextPreservingRunnable(command);
    }

    public Runnable unwrap(Runnable command) {
        if (command instanceof ContextPreservingAbstractRunnable) {
            return ((ContextPreservingAbstractRunnable)command).unwrap();
        }
        if (command instanceof ContextPreservingRunnable) {
            return ((ContextPreservingRunnable)command).unwrap();
        }
        return command;
    }

    boolean isDefaultContext() {
        return this.threadLocal.get() == DEFAULT_CONTEXT;
    }

    public void markAsSystemContext() {
        this.threadLocal.set(this.threadLocal.get().setSystemContext());
    }

    public boolean isSystemContext() {
        return this.threadLocal.get().isSystemContext;
    }

    boolean isClosed() {
        return this.threadLocal.closed.get();
    }

    private class ContextPreservingAbstractRunnable
    extends AbstractRunnable {
        private final AbstractRunnable in;
        private final StoredContext creatorsContext;
        private StoredContext threadsOriginalContext = null;

        private ContextPreservingAbstractRunnable(AbstractRunnable in) {
            this.creatorsContext = ThreadContext.this.newStoredContext(false);
            this.in = in;
        }

        @Override
        public boolean isForceExecution() {
            return this.in.isForceExecution();
        }

        @Override
        public void onAfter() {
            try {
                this.in.onAfter();
            }
            finally {
                if (this.threadsOriginalContext != null) {
                    this.threadsOriginalContext.restore();
                }
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.in.onFailure(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.in.onRejection(e);
        }

        @Override
        protected void doRun() throws Exception {
            block2: {
                boolean whileRunning = false;
                this.threadsOriginalContext = ThreadContext.this.stashContext();
                try {
                    this.creatorsContext.restore();
                    whileRunning = true;
                    this.in.doRun();
                    whileRunning = false;
                }
                catch (IllegalStateException ex) {
                    if (!whileRunning && ThreadContext.this.threadLocal.closed.get()) break block2;
                    throw ex;
                }
            }
        }

        public String toString() {
            return this.in.toString();
        }

        public AbstractRunnable unwrap() {
            return this.in;
        }
    }

    private class ContextPreservingRunnable
    implements Runnable {
        private final Runnable in;
        private final StoredContext ctx;

        private ContextPreservingRunnable(Runnable in) {
            this.ctx = ThreadContext.this.newStoredContext(false);
            this.in = in;
        }

        @Override
        public void run() {
            block20: {
                boolean whileRunning = false;
                try (StoredContext ignore = ThreadContext.this.stashContext();){
                    block19: {
                        this.ctx.restore();
                        whileRunning = true;
                        this.in.run();
                        if (this.in instanceof RunnableFuture) {
                            try {
                                ((RunnableFuture)this.in).get();
                            }
                            catch (Exception e) {
                                assert (e instanceof CancellationException || e instanceof InterruptedException || e instanceof ExecutionException) : e;
                                Optional<Error> maybeError = ExceptionsHelper.maybeError(e, ESLoggerFactory.getLogger(ThreadContext.class));
                                if (maybeError.isPresent()) {
                                    throw maybeError.get();
                                }
                                if (!(e instanceof InterruptedException)) break block19;
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    whileRunning = false;
                }
                catch (IllegalStateException ex) {
                    if (!whileRunning && ThreadContext.this.threadLocal.closed.get()) break block20;
                    throw ex;
                }
            }
        }

        public String toString() {
            return this.in.toString();
        }

        public Runnable unwrap() {
            return this.in;
        }
    }

    private static class ContextThreadLocal
    extends CloseableThreadLocal<ThreadContextStruct> {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private ContextThreadLocal() {
        }

        @Override
        public void set(ThreadContextStruct object) {
            try {
                if (object == DEFAULT_CONTEXT) {
                    super.set(null);
                } else {
                    super.set(object);
                }
            }
            catch (NullPointerException ex) {
                this.ensureOpen();
                throw ex;
            }
        }

        @Override
        public ThreadContextStruct get() {
            try {
                ThreadContextStruct threadContextStruct = (ThreadContextStruct)super.get();
                if (threadContextStruct != null) {
                    return threadContextStruct;
                }
                return DEFAULT_CONTEXT;
            }
            catch (NullPointerException ex) {
                this.ensureOpen();
                throw ex;
            }
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new IllegalStateException("threadcontext is already closed");
            }
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                super.close();
            }
        }
    }

    private static final class ThreadContextStruct {
        private final Map<String, String> requestHeaders;
        private final Map<String, Object> transientHeaders;
        private final Map<String, List<String>> responseHeaders;
        private final boolean isSystemContext;

        private ThreadContextStruct(StreamInput in) throws IOException {
            int numRequest = in.readVInt();
            HashMap<String, String> requestHeaders = numRequest == 0 ? Collections.emptyMap() : new HashMap<String, String>(numRequest);
            for (int i = 0; i < numRequest; ++i) {
                requestHeaders.put(in.readString(), in.readString());
            }
            this.requestHeaders = requestHeaders;
            this.responseHeaders = in.readMapOfLists(StreamInput::readString, StreamInput::readString);
            this.transientHeaders = Collections.emptyMap();
            this.isSystemContext = false;
        }

        private ThreadContextStruct setSystemContext() {
            if (this.isSystemContext) {
                return this;
            }
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, true);
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, List<String>> responseHeaders, Map<String, Object> transientHeaders, boolean isSystemContext) {
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
            this.transientHeaders = transientHeaders;
            this.isSystemContext = isSystemContext;
        }

        private ThreadContextStruct() {
            this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        }

        private ThreadContextStruct putRequest(String key, String value) {
            HashMap<String, String> newRequestHeaders = new HashMap<String, String>(this.requestHeaders);
            this.putSingleHeader(key, value, newRequestHeaders);
            return new ThreadContextStruct(newRequestHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private void putSingleHeader(String key, String value, Map<String, String> newHeaders) {
            if (newHeaders.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("value for key [" + key + "] already present");
            }
        }

        private ThreadContextStruct putHeaders(Map<String, String> headers) {
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, String> newHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.putSingleHeader(entry.getKey(), entry.getValue(), newHeaders);
            }
            newHeaders.putAll(this.requestHeaders);
            return new ThreadContextStruct(newHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponseHeaders(Map<String, List<String>> headers) {
            assert (headers != null);
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, List<String>> newResponseHeaders = new HashMap<String, List<String>>(this.responseHeaders);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List existingValues = (List)newResponseHeaders.get(key);
                if (existingValues != null) {
                    List newValues = Stream.concat(entry.getValue().stream(), existingValues.stream()).distinct().collect(Collectors.toList());
                    newResponseHeaders.put(key, Collections.unmodifiableList(newValues));
                    continue;
                }
                newResponseHeaders.put(key, entry.getValue());
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponse(String key, String value, Function<String, String> uniqueValue) {
            assert (value != null);
            HashMap<String, List<String>> newResponseHeaders = new HashMap<String, List<String>>(this.responseHeaders);
            List existingValues = (List)newResponseHeaders.get(key);
            if (existingValues != null) {
                Set existingUniqueValues = existingValues.stream().map(uniqueValue).collect(Collectors.toSet());
                assert (existingValues.size() == existingUniqueValues.size()) : "existing values: [" + existingValues + "], existing unique values [" + existingUniqueValues + "]";
                if (existingUniqueValues.contains(uniqueValue.apply(value))) {
                    return this;
                }
                ArrayList<String> newValues = new ArrayList<String>(existingValues);
                newValues.add(value);
                newResponseHeaders.put(key, Collections.unmodifiableList(newValues));
            } else {
                newResponseHeaders.put(key, Collections.singletonList(value));
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putTransient(String key, Object value) {
            HashMap<String, Object> newTransient = new HashMap<String, Object>(this.transientHeaders);
            if (newTransient.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("value for key [" + key + "] already present");
            }
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, newTransient, this.isSystemContext);
        }

        boolean isEmpty() {
            return this.requestHeaders.isEmpty() && this.responseHeaders.isEmpty() && this.transientHeaders.isEmpty();
        }

        private ThreadContextStruct copyHeaders(Iterable<Map.Entry<String, String>> headers) {
            HashMap<String, String> newHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> header : headers) {
                newHeaders.put(header.getKey(), header.getValue());
            }
            return this.putHeaders(newHeaders);
        }

        private void writeTo(StreamOutput out, Map<String, String> defaultHeaders) throws IOException {
            Map<String, String> requestHeaders;
            if (defaultHeaders.isEmpty()) {
                requestHeaders = this.requestHeaders;
            } else {
                requestHeaders = new HashMap<String, String>(defaultHeaders);
                requestHeaders.putAll(this.requestHeaders);
            }
            out.writeVInt(requestHeaders.size());
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
            out.writeMapOfLists(this.responseHeaders, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    @FunctionalInterface
    public static interface StoredContext
    extends AutoCloseable {
        @Override
        public void close();

        default public void restore() {
            this.close();
        }
    }
}

