/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.util.regex.Pattern;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.pattern.PatternTokenizer;

public final class PatternAnalyzer
extends Analyzer {
    private final Pattern pattern;
    private final boolean lowercase;
    private final CharArraySet stopWords;

    public PatternAnalyzer(Pattern pattern, boolean lowercase, CharArraySet stopWords) {
        this.pattern = pattern;
        this.lowercase = lowercase;
        this.stopWords = stopWords;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String s) {
        PatternTokenizer tokenizer;
        TokenStream stream = tokenizer = new PatternTokenizer(this.pattern, -1);
        if (this.lowercase) {
            stream = new LowerCaseFilter(stream);
        }
        if (this.stopWords != null) {
            stream = new StopFilter(stream, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents(tokenizer, stream);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream stream = in;
        if (this.lowercase) {
            stream = new LowerCaseFilter(stream);
        }
        return stream;
    }
}

