/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.shingle.ShingleFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TokenFilterFactory;

public class ShingleTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Factory factory;

    public ShingleTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        Integer maxShingleSize = settings.getAsInt("max_shingle_size", 2);
        Integer minShingleSize = settings.getAsInt("min_shingle_size", 2);
        Boolean outputUnigrams = settings.getAsBoolean("output_unigrams", true);
        Boolean outputUnigramsIfNoShingles = settings.getAsBoolean("output_unigrams_if_no_shingles", false);
        String tokenSeparator = settings.get("token_separator", " ");
        String fillerToken = settings.get("filler_token", "_");
        this.factory = new Factory("shingle", minShingleSize, maxShingleSize, outputUnigrams, outputUnigramsIfNoShingles, tokenSeparator, fillerToken);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return this.factory.create(tokenStream);
    }

    public Factory getInnerFactory() {
        return this.factory;
    }

    public static final class Factory
    implements TokenFilterFactory {
        private final int maxShingleSize;
        private final boolean outputUnigrams;
        private final boolean outputUnigramsIfNoShingles;
        private final String tokenSeparator;
        private final String fillerToken;
        private int minShingleSize;
        private final String name;

        public Factory(String name) {
            this(name, 2, 2, true, false, " ", "_");
        }

        Factory(String name, int minShingleSize, int maxShingleSize, boolean outputUnigrams, boolean outputUnigramsIfNoShingles, String tokenSeparator, String fillerToken) {
            this.maxShingleSize = maxShingleSize;
            this.outputUnigrams = outputUnigrams;
            this.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
            this.tokenSeparator = tokenSeparator;
            this.minShingleSize = minShingleSize;
            this.fillerToken = fillerToken;
            this.name = name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            ShingleFilter filter = new ShingleFilter(tokenStream, this.minShingleSize, this.maxShingleSize);
            filter.setOutputUnigrams(this.outputUnigrams);
            filter.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
            filter.setTokenSeparator(this.tokenSeparator);
            filter.setFillerToken(this.fillerToken);
            if (this.outputUnigrams || this.minShingleSize != this.maxShingleSize) {
                filter.addAttribute(DisableGraphAttribute.class);
            }
            return filter;
        }

        public int getMaxShingleSize() {
            return this.maxShingleSize;
        }

        public int getMinShingleSize() {
            return this.minShingleSize;
        }

        public boolean getOutputUnigrams() {
            return this.outputUnigrams;
        }

        public boolean getOutputUnigramsIfNoShingles() {
            return this.outputUnigramsIfNoShingles;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

