/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedBinaryDocValues;

final class SingletonSortedBinaryDocValues
extends SortedBinaryDocValues {
    private final BinaryDocValues in;
    private final Bits docsWithField;
    private BytesRef value;
    private int count;

    SingletonSortedBinaryDocValues(BinaryDocValues in, Bits docsWithField) {
        this.in = in;
        this.docsWithField = docsWithField instanceof Bits.MatchAllBits ? null : docsWithField;
    }

    @Override
    public void setDocument(int docID) {
        this.value = this.in.get(docID);
        this.count = this.value.length == 0 && this.docsWithField != null && !this.docsWithField.get(docID) ? 0 : 1;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public BytesRef valueAt(int index) {
        assert (index == 0);
        return this.value;
    }

    public BinaryDocValues getBinaryDocValues() {
        return this.in;
    }

    public Bits getDocsWithField() {
        return this.docsWithField;
    }
}

