/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ordinals;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.LongValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AbstractRandomAccessOrds;

public class GlobalOrdinalMapping
extends AbstractRandomAccessOrds {
    private final RandomAccessOrds values;
    private final MultiDocValues.OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final RandomAccessOrds[] bytesValues;

    GlobalOrdinalMapping(MultiDocValues.OrdinalMap ordinalMap, RandomAccessOrds[] bytesValues, int segmentIndex) {
        this.values = bytesValues[segmentIndex];
        this.bytesValues = bytesValues;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    @Override
    public long getValueCount() {
        return this.ordinalMap.getValueCount();
    }

    public final long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    @Override
    public long ordAt(int index) {
        return this.getGlobalOrd(this.values.ordAt(index));
    }

    @Override
    public void doSetDocument(int docId) {
        this.values.setDocument(docId);
    }

    @Override
    public int cardinality() {
        return this.values.cardinality();
    }

    @Override
    public BytesRef lookupOrd(long globalOrd) {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        return this.bytesValues[readerIndex].lookupOrd(segmentOrd);
    }
}

