/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.bootstrap.JarHell;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;

public class PluginInfo
implements Writeable,
ToXContent {
    public static final String ES_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    public static final String ES_PLUGIN_POLICY = "plugin-security.policy";
    private final String name;
    private final String description;
    private final String version;
    private final String classname;
    private final boolean hasNativeController;

    public PluginInfo(String name, String description, String version, String classname, boolean hasNativeController) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.classname = classname;
        this.hasNativeController = hasNativeController;
    }

    public PluginInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.version = in.readString();
        this.classname = in.readString();
        this.hasNativeController = in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.version);
        out.writeString(this.classname);
        if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
            out.writeBoolean(this.hasNativeController);
        }
    }

    public static PluginInfo readFromProperties(Path path) throws IOException {
        boolean hasNativeController;
        Path descriptor = path.resolve(ES_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        String name = props.getProperty("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing in [" + descriptor + "]");
        }
        String description = props.getProperty("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for plugin [" + name + "]");
        }
        String version = props.getProperty("version");
        if (version == null) {
            throw new IllegalArgumentException("property [version] is missing for plugin [" + name + "]");
        }
        String esVersionString = props.getProperty("elasticsearch.version");
        if (esVersionString == null) {
            throw new IllegalArgumentException("property [elasticsearch.version] is missing for plugin [" + name + "]");
        }
        Version esVersion = Version.fromString(esVersionString);
        if (!esVersion.equals(Version.CURRENT)) {
            String message = String.format(Locale.ROOT, "plugin [%s] is incompatible with version [%s]; was designed for version [%s]", name, Version.CURRENT.toString(), esVersionString);
            throw new IllegalArgumentException(message);
        }
        String javaVersionString = props.getProperty("java.version");
        if (javaVersionString == null) {
            throw new IllegalArgumentException("property [java.version] is missing for plugin [" + name + "]");
        }
        JarHell.checkVersionFormat(javaVersionString);
        JarHell.checkJavaVersion(name, javaVersionString);
        String classname = props.getProperty("classname");
        if (classname == null) {
            throw new IllegalArgumentException("property [classname] is missing for plugin [" + name + "]");
        }
        String hasNativeControllerValue = props.getProperty("has.native.controller");
        if (hasNativeControllerValue == null) {
            hasNativeController = false;
        } else {
            switch (hasNativeControllerValue) {
                case "true": {
                    hasNativeController = true;
                    break;
                }
                case "false": {
                    hasNativeController = false;
                    break;
                }
                default: {
                    String message = String.format(Locale.ROOT, "property [%s] must be [%s], [%s], or unspecified but was [%s]", "has_native_controller", "true", "false", hasNativeControllerValue);
                    throw new IllegalArgumentException(message);
                }
            }
        }
        return new PluginInfo(name, description, version, classname, hasNativeController);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("version", this.version);
        builder.field("description", this.description);
        builder.field("classname", this.classname);
        builder.field("has_native_controller", this.hasNativeController);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder information = new StringBuilder().append("- Plugin information:\n").append("Name: ").append(this.name).append("\n").append("Description: ").append(this.description).append("\n").append("Version: ").append(this.version).append("\n").append("Native Controller: ").append(this.hasNativeController).append("\n").append(" * Classname: ").append(this.classname);
        return information.toString();
    }
}

