/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.PluginInfo;

class PluginSecurity {
    PluginSecurity() {
    }

    static void readPolicy(PluginInfo info, Path file, Terminal terminal, Supplier<Path> tmpFile, boolean batch) throws IOException {
        PermissionCollection permissions = PluginSecurity.parsePermissions(terminal, file, tmpFile.get());
        ArrayList<Permission> requested = Collections.list(permissions.elements());
        if (requested.isEmpty()) {
            terminal.println(Terminal.Verbosity.VERBOSE, "plugin has a policy file with no additional permissions");
        } else {
            Collections.sort(requested, new Comparator<Permission>(){

                @Override
                public int compare(Permission o1, Permission o2) {
                    int cmp = o1.getClass().getName().compareTo(o2.getClass().getName());
                    if (cmp == 0) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        if (name1 == null) {
                            name1 = "";
                        }
                        if (name2 == null) {
                            name2 = "";
                        }
                        if ((cmp = name1.compareTo(name2)) == 0) {
                            String actions1 = o1.getActions();
                            String actions2 = o2.getActions();
                            if (actions1 == null) {
                                actions1 = "";
                            }
                            if (actions2 == null) {
                                actions2 = "";
                            }
                            cmp = actions1.compareTo(actions2);
                        }
                    }
                    return cmp;
                }
            });
            terminal.println(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            terminal.println(Terminal.Verbosity.NORMAL, "@     WARNING: plugin requires additional permissions     @");
            terminal.println(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            for (Permission permission : requested) {
                terminal.println(Terminal.Verbosity.NORMAL, "* " + PluginSecurity.formatPermission(permission));
            }
            terminal.println(Terminal.Verbosity.NORMAL, "See http://docs.oracle.com/javase/8/docs/technotes/guides/security/permissions.html");
            terminal.println(Terminal.Verbosity.NORMAL, "for descriptions of what these permissions allow and the associated risks.");
            PluginSecurity.prompt(terminal, batch);
        }
        if (info.hasNativeController()) {
            terminal.println(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            terminal.println(Terminal.Verbosity.NORMAL, "@        WARNING: plugin forks a native controller        @");
            terminal.println(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            terminal.println(Terminal.Verbosity.NORMAL, "This plugin launches a native controller that is not subject to the Java");
            terminal.println(Terminal.Verbosity.NORMAL, "security manager nor to system call filters.");
            PluginSecurity.prompt(terminal, batch);
        }
    }

    private static void prompt(Terminal terminal, boolean batch) {
        if (!batch) {
            terminal.println(Terminal.Verbosity.NORMAL, "");
            String text = terminal.readText("Continue with installation? [y/N]");
            if (!text.equalsIgnoreCase("y")) {
                throw new RuntimeException("installation aborted by user");
            }
        }
    }

    static String formatPermission(Permission permission) {
        StringBuilder sb = new StringBuilder();
        String clazz = null;
        clazz = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedType() : permission.getClass().getName();
        sb.append(clazz);
        String name = null;
        name = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedName() : permission.getName();
        if (name != null && name.length() > 0) {
            sb.append(' ');
            sb.append(name);
        }
        String actions = null;
        actions = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedActions() : permission.getActions();
        if (actions != null && actions.length() > 0) {
            sb.append(' ');
            sb.append(actions);
        }
        return sb.toString();
    }

    static PermissionCollection parsePermissions(Terminal terminal, Path file, Path tmpDir) throws IOException {
        Policy policy;
        Policy emptyPolicy;
        Path emptyPolicyFile = Files.createTempFile(tmpDir, "empty", "tmp", new FileAttribute[0]);
        try {
            emptyPolicy = Policy.getInstance("JavaPolicy", new URIParameter(emptyPolicyFile.toUri()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        IOUtils.rm(emptyPolicyFile);
        try {
            policy = Policy.getInstance("JavaPolicy", new URIParameter(file.toUri()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        PermissionCollection permissions = policy.getPermissions(PluginSecurity.class.getProtectionDomain());
        if (permissions == Policy.UNSUPPORTED_EMPTY_COLLECTION) {
            throw new UnsupportedOperationException("JavaPolicy implementation does not support retrieving permissions");
        }
        Permissions actualPermissions = new Permissions();
        for (Permission permission : Collections.list(permissions.elements())) {
            if (emptyPolicy.implies(PluginSecurity.class.getProtectionDomain(), permission)) continue;
            ((PermissionCollection)actualPermissions).add(permission);
        }
        actualPermissions.setReadOnly();
        return actualPermissions;
    }
}

