/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.breaker.CircuitBreaker;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesArray;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.Streams;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.path.PathTrie;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.http.HttpServerTransport;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.http.HttpTransportSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.DeprecationRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestUtils;

public class RestController
extends AbstractComponent
implements HttpServerTransport.Dispatcher {
    private final PathTrie<RestHandler> getHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> postHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> putHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> deleteHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> headHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> optionsHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final UnaryOperator<RestHandler> handlerWrapper;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;
    private final Set<String> headersToCopy;
    private final boolean isContentTypeRequired;
    private final DeprecationLogger deprecationLogger;

    public RestController(Settings settings, Set<String> headersToCopy, UnaryOperator<RestHandler> handlerWrapper, NodeClient client, CircuitBreakerService circuitBreakerService) {
        super(settings);
        this.headersToCopy = headersToCopy;
        if (handlerWrapper == null) {
            handlerWrapper = h -> h;
        }
        this.handlerWrapper = handlerWrapper;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
        this.isContentTypeRequired = HttpTransportSettings.SETTING_HTTP_CONTENT_TYPE_REQUIRED.get(settings);
        this.deprecationLogger = new DeprecationLogger(this.logger);
    }

    public void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, String deprecationMessage, DeprecationLogger logger) {
        assert (!(handler instanceof DeprecationRestHandler));
        this.registerHandler(method, path, new DeprecationRestHandler(handler, deprecationMessage, logger));
    }

    public void registerWithDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, RestRequest.Method deprecatedMethod, String deprecatedPath, DeprecationLogger logger) {
        String deprecationMessage = "[" + deprecatedMethod.name() + " " + deprecatedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, handler);
        this.registerAsDeprecatedHandler(deprecatedMethod, deprecatedPath, handler, deprecationMessage, logger);
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        PathTrie<RestHandler> handlers = this.getHandlersForMethod(method);
        if (handlers == null) {
            throw new IllegalArgumentException("Can't handle [" + (Object)((Object)method) + "] for path [" + path + "]");
        }
        handlers.insert(path, handler);
    }

    public boolean canTripCircuitBreaker(RestRequest request) {
        RestHandler handler = this.getHandler(request);
        return handler != null ? handler.canTripCircuitBreaker() : true;
    }

    @Override
    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        if (request.rawPath().equals("/favicon.ico")) {
            this.handleFavicon(request, channel);
            return;
        }
        RestChannel responseChannel = channel;
        try {
            int contentLength;
            int n = contentLength = request.hasContent() ? request.content().length() : 0;
            assert (contentLength >= 0) : "content length was negative, how is that possible?";
            RestHandler handler = this.getHandler(request);
            if (contentLength > 0 && !this.hasContentTypeOrCanAutoDetect(request, handler)) {
                this.sendContentTypeErrorMessage(request, responseChannel);
            } else if (contentLength > 0 && handler != null && handler.supportsContentStream() && request.getXContentType() != XContentType.JSON && request.getXContentType() != XContentType.SMILE) {
                responseChannel.sendResponse(BytesRestResponse.createSimpleErrorResponse(responseChannel, RestStatus.NOT_ACCEPTABLE, "Content-Type [" + request.getXContentType() + "] does not support stream parsing. Use JSON or SMILE instead"));
            } else {
                if (this.canTripCircuitBreaker(request)) {
                    RestController.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
                } else {
                    RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
                }
                responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength);
                this.dispatchRequest(request, responseChannel, this.client, threadContext, handler);
            }
        }
        catch (Exception e) {
            try {
                responseChannel.sendResponse(new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
            }
        }
    }

    @Override
    public void dispatchBadRequest(RestRequest request, RestChannel channel, ThreadContext threadContext, Throwable cause) {
        try {
            Exception e = cause == null ? new ElasticsearchException("unknown cause", new Object[0]) : (cause instanceof Exception ? (Exception)cause : new ElasticsearchException(cause));
            channel.sendResponse(new BytesRestResponse(channel, RestStatus.BAD_REQUEST, e));
        }
        catch (IOException e) {
            if (cause != null) {
                e.addSuppressed(cause);
            }
            this.logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    void dispatchRequest(RestRequest request, RestChannel channel, NodeClient client, ThreadContext threadContext, RestHandler handler) throws Exception {
        if (!this.checkRequestParameters(request, channel)) {
            channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "error traces in responses are disabled."));
        } else {
            for (String key : this.headersToCopy) {
                String httpHeader = request.header(key);
                if (httpHeader == null) continue;
                threadContext.putHeader(key, httpHeader);
            }
            if (handler == null) {
                if (request.method() == RestRequest.Method.OPTIONS) {
                    channel.sendResponse(new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY));
                } else {
                    String msg = "No handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]";
                    channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, msg));
                }
            } else {
                RestHandler wrappedHandler = (RestHandler)Objects.requireNonNull(this.handlerWrapper.apply(handler));
                wrappedHandler.handleRequest(request, channel, client);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasContentTypeOrCanAutoDetect(RestRequest restRequest, RestHandler restHandler) {
        if (restRequest.getXContentType() != null) return true;
        if (restHandler != null && restHandler.supportsPlainText()) {
            if (this.isContentTypeRequired) {
                this.deprecationLogger.deprecated("Plain text request bodies are deprecated. Use request parameters or body in a supported format.", new Object[0]);
                return true;
            }
            boolean detected = this.autoDetectXContentType(restRequest);
            if (detected) return true;
            this.deprecationLogger.deprecated("Plain text request bodies are deprecated. Use request parameters or body in a supported format.", new Object[0]);
            return true;
        }
        if (restHandler != null && restHandler.supportsContentStream() && restRequest.header("Content-Type") != null) {
            String lowercaseMediaType = restRequest.header("Content-Type").toLowerCase(Locale.ROOT);
            if (lowercaseMediaType.equals("application/x-ndjson")) {
                restRequest.setXContentType(XContentType.JSON);
                return true;
            }
            if (lowercaseMediaType.equals("application/x-ldjson")) {
                restRequest.setXContentType(XContentType.JSON);
                this.deprecationLogger.deprecated("The Content-Type [application/x-ldjson] has been superseded by [application/x-ndjson] in the specification and should be used instead.", new Object[0]);
                return true;
            }
            if (!this.isContentTypeRequired) return this.autoDetectXContentType(restRequest);
            return false;
        }
        if (!this.isContentTypeRequired) return this.autoDetectXContentType(restRequest);
        return false;
    }

    private boolean autoDetectXContentType(RestRequest restRequest) {
        this.deprecationLogger.deprecated("Content type detection for rest requests is deprecated. Specify the content type using the [Content-Type] header.", new Object[0]);
        XContentType xContentType = XContentFactory.xContentType(restRequest.content());
        if (xContentType == null) {
            return false;
        }
        restRequest.setXContentType(xContentType);
        return true;
    }

    private void sendContentTypeErrorMessage(RestRequest restRequest, RestChannel channel) throws IOException {
        List<String> contentTypeHeader = restRequest.getAllHeaderValues("Content-Type");
        String errorMessage = contentTypeHeader == null ? "Content-Type header is missing" : "Content-Type header [" + Strings.collectionToCommaDelimitedString(restRequest.getAllHeaderValues("Content-Type")) + "] is not supported";
        channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, errorMessage));
    }

    boolean checkRequestParameters(RestRequest request, RestChannel channel) {
        return !request.paramAsBoolean("error_trace", false) || channel.detailedErrorsEnabled();
    }

    private RestHandler getHandler(RestRequest request) {
        String path = this.getPath(request);
        PathTrie<RestHandler> handlers = this.getHandlersForMethod(request.method());
        if (handlers != null) {
            return handlers.retrieve(path, request.params());
        }
        return null;
    }

    private PathTrie<RestHandler> getHandlersForMethod(RestRequest.Method method) {
        if (method == RestRequest.Method.GET) {
            return this.getHandlers;
        }
        if (method == RestRequest.Method.POST) {
            return this.postHandlers;
        }
        if (method == RestRequest.Method.PUT) {
            return this.putHandlers;
        }
        if (method == RestRequest.Method.DELETE) {
            return this.deleteHandlers;
        }
        if (method == RestRequest.Method.HEAD) {
            return this.headHandlers;
        }
        if (method == RestRequest.Method.OPTIONS) {
            return this.optionsHandlers;
        }
        return null;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }

    void handleFavicon(RestRequest request, RestChannel channel) {
        if (request.method() == RestRequest.Method.GET) {
            try (InputStream stream = this.getClass().getResourceAsStream("/config/favicon.ico");){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy(stream, (OutputStream)out);
                BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, "image/x-icon", out.toByteArray());
                channel.sendResponse(restResponse);
            }
            catch (IOException e) {
                channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
            }
        } else {
            channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final AtomicBoolean closed = new AtomicBoolean();

        ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable XContentType xContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, useFiltering);
        }

        @Override
        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.contentLength);
        }
    }
}

