/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestActions;

public class RestNodesStatsAction
extends BaseRestHandler {
    static final Map<String, Consumer<NodesStatsRequest>> METRICS;
    static final Map<String, Consumer<CommonStatsFlags>> FLAGS;
    private final Set<String> RESPONSE_PARAMS = Collections.singleton("level");

    public RestNodesStatsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/stats/{metric}/{index_metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}/{index_metric}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> metrics = Strings.splitStringByCommaToSet(request.param("metric", "_all"));
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(nodesIds);
        nodesStatsRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            if (request.hasParam("index_metric")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but all stats requested", request.path(), request.param("index_metric")));
            }
            nodesStatsRequest.all();
            nodesStatsRequest.indices(CommonStatsFlags.ALL);
        } else {
            if (metrics.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
            }
            nodesStatsRequest.clear();
            TreeSet<String> invalidMetrics = new TreeSet<String>();
            for (String metric : metrics) {
                Consumer<NodesStatsRequest> handler = METRICS.get(metric);
                if (handler != null) {
                    handler.accept(nodesStatsRequest);
                    continue;
                }
                invalidMetrics.add(metric);
            }
            if (!invalidMetrics.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidMetrics, METRICS.keySet(), "metric"));
            }
            if (metrics.contains("indices")) {
                Set<String> indexMetrics = Strings.splitStringByCommaToSet(request.param("index_metric", "_all"));
                if (indexMetrics.size() == 1 && indexMetrics.contains("_all")) {
                    nodesStatsRequest.indices(CommonStatsFlags.ALL);
                } else {
                    CommonStatsFlags flags = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
                    flags.clear();
                    TreeSet<String> invalidIndexMetrics = new TreeSet<String>();
                    for (String indexMetric : indexMetrics) {
                        Consumer<CommonStatsFlags> handler = FLAGS.get(indexMetric);
                        if (handler != null) {
                            handler.accept(flags);
                            continue;
                        }
                        invalidIndexMetrics.add(indexMetric);
                    }
                    if (invalidIndexMetrics.contains("percolate")) {
                        this.deprecationLogger.deprecated("percolate stats are no longer available and requests for percolate stats will fail starting in 6.0.0", new Object[0]);
                        invalidIndexMetrics.remove("percolate");
                    }
                    if (!invalidIndexMetrics.isEmpty()) {
                        throw new IllegalArgumentException(this.unrecognized(request, invalidIndexMetrics, FLAGS.keySet(), "index metric"));
                    }
                    nodesStatsRequest.indices(flags);
                }
            } else if (request.hasParam("index_metric")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but indices stats not requested", request.path(), request.param("index_metric")));
            }
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.FieldData) && (request.hasParam("fields") || request.hasParam("fielddata_fields"))) {
            nodesStatsRequest.indices().fieldDataFields(request.paramAsStringArray("fielddata_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Completion) && (request.hasParam("fields") || request.hasParam("completion_fields"))) {
            nodesStatsRequest.indices().completionDataFields(request.paramAsStringArray("completion_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Search) && request.hasParam("groups")) {
            nodesStatsRequest.indices().groups(request.paramAsStringArray("groups", null));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Indexing) && request.hasParam("types")) {
            nodesStatsRequest.indices().types(request.paramAsStringArray("types", null));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Segments)) {
            nodesStatsRequest.indices().includeSegmentFileSizes(request.paramAsBoolean("include_segment_file_sizes", false));
        }
        return channel -> client.admin().cluster().nodesStats(nodesStatsRequest, new RestActions.NodesResponseRestListener<NodesStatsResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return this.RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        HashMap<String, Consumer<NodesStatsRequest>> metrics = new HashMap<String, Consumer<NodesStatsRequest>>();
        metrics.put("os", r -> r.os(true));
        metrics.put("jvm", r -> r.jvm(true));
        metrics.put("thread_pool", r -> r.threadPool(true));
        metrics.put("fs", r -> r.fs(true));
        metrics.put("transport", r -> r.transport(true));
        metrics.put("http", r -> r.http(true));
        metrics.put("indices", r -> r.indices(true));
        metrics.put("process", r -> r.process(true));
        metrics.put("breaker", r -> r.breaker(true));
        metrics.put("script", r -> r.script(true));
        metrics.put("discovery", r -> r.discovery(true));
        metrics.put("ingest", r -> r.ingest(true));
        METRICS = Collections.unmodifiableMap(metrics);
        HashMap<String, Consumer<CommonStatsFlags>> flags = new HashMap<String, Consumer<CommonStatsFlags>>();
        for (CommonStatsFlags.Flag flag : CommonStatsFlags.Flag.values()) {
            flags.put(flag.getRestName(), f -> f.set(flag, true));
        }
        FLAGS = Collections.unmodifiableMap(flags);
    }
}

