/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.ArrayList;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestToXContentListener;

public class RestAnalyzeAction
extends BaseRestHandler {
    public RestAnalyzeAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_analyze", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_analyze", this);
        controller.registerHandler(RestRequest.Method.POST, "/_analyze", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_analyze", this);
    }

    private void deprecationLog(String key, RestRequest request) {
        if (request.hasParam(key)) {
            this.deprecationLogWithoutCheck(key);
        }
    }

    private void deprecationLogWithoutCheck(String key) {
        this.deprecationLogForText(key + " request parameter is deprecated and will be removed in the next major release. Please use the JSON in the request body instead request param");
    }

    void deprecationLogForText(String msg) {
        this.deprecationLogger.deprecated(msg, new Object[0]);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] texts = request.paramAsStringArrayOrEmptyIfAll("text");
        this.deprecationLog("text", request);
        AnalyzeRequest analyzeRequest = new AnalyzeRequest(request.param("index"));
        analyzeRequest.text(texts);
        analyzeRequest.analyzer(request.param("analyzer"));
        this.deprecationLog("analyzer", request);
        analyzeRequest.field(request.param("field"));
        this.deprecationLog("field", request);
        String tokenizer = request.param("tokenizer");
        if (tokenizer != null) {
            analyzeRequest.tokenizer(tokenizer);
            this.deprecationLogWithoutCheck("tokenizer");
        }
        for (String filter : request.paramAsStringArray("filter", Strings.EMPTY_ARRAY)) {
            analyzeRequest.addTokenFilter(filter);
            this.deprecationLogWithoutCheck("filter");
        }
        for (String charFilter : request.paramAsStringArray("char_filter", Strings.EMPTY_ARRAY)) {
            analyzeRequest.addTokenFilter(charFilter);
            this.deprecationLogWithoutCheck("char_filter");
        }
        analyzeRequest.explain(request.paramAsBoolean("explain", false));
        this.deprecationLog("explain", request);
        analyzeRequest.attributes(request.paramAsStringArray("attributes", analyzeRequest.attributes()));
        this.deprecationLog("attributes", request);
        try {
            this.handleBodyContent(request, texts, analyzeRequest);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse request body", e);
        }
        return channel -> client.admin().indices().analyze(analyzeRequest, new RestToXContentListener<AnalyzeResponse>((RestChannel)channel));
    }

    void handleBodyContent(RestRequest request, String[] texts, AnalyzeRequest analyzeRequest) throws IOException {
        request.withContentOrSourceParamParserOrNullLenient(parser -> {
            if (parser == null) {
                if (request.hasContent()) {
                    BytesReference body = request.getContentOrSourceParamOnly();
                    if (texts == null || texts.length == 0) {
                        String[] localTexts = new String[]{body.utf8ToString()};
                        analyzeRequest.text(localTexts);
                        this.deprecationLogForText(" plain text bodies is deprecated and this feature will be removed in the next major release. Please use the text param in JSON");
                    }
                }
            } else {
                RestAnalyzeAction.buildFromContent(parser, analyzeRequest);
            }
        });
    }

    @Override
    public boolean supportsPlainText() {
        return true;
    }

    static void buildFromContent(XContentParser parser, AnalyzeRequest analyzeRequest) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Fields.TEXT.match(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                analyzeRequest.text(parser.text());
                continue;
            }
            if (Fields.TEXT.match(currentFieldName) && token == XContentParser.Token.START_ARRAY) {
                ArrayList<String> texts = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new IllegalArgumentException(currentFieldName + " array element should only contain text");
                    }
                    texts.add(parser.text());
                }
                analyzeRequest.text(texts.toArray(new String[texts.size()]));
                continue;
            }
            if (Fields.ANALYZER.match(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                analyzeRequest.analyzer(parser.text());
                continue;
            }
            if (Fields.FIELD.match(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                analyzeRequest.field(parser.text());
                continue;
            }
            if (Fields.TOKENIZER.match(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.tokenizer(parser.text());
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    analyzeRequest.tokenizer(parser.map());
                    continue;
                }
                throw new IllegalArgumentException(currentFieldName + " should be tokenizer's name or setting");
            }
            if (Fields.TOKEN_FILTERS.match(currentFieldName) && token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        analyzeRequest.addTokenFilter(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        analyzeRequest.addTokenFilter(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException(currentFieldName + " array element should contain filter's name or setting");
                }
                continue;
            }
            if (Fields.CHAR_FILTERS.match(currentFieldName) && token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        analyzeRequest.addCharFilter(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        analyzeRequest.addCharFilter(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException(currentFieldName + " array element should contain char filter's name or setting");
                }
                continue;
            }
            if (Fields.EXPLAIN.match(currentFieldName)) {
                if (parser.isBooleanValue()) {
                    analyzeRequest.explain(parser.booleanValue());
                    continue;
                }
                throw new IllegalArgumentException(currentFieldName + " must be either 'true' or 'false'");
            }
            if (Fields.ATTRIBUTES.match(currentFieldName) && token == XContentParser.Token.START_ARRAY) {
                ArrayList<String> attributes = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new IllegalArgumentException(currentFieldName + " array element should only contain attribute name");
                    }
                    attributes.add(parser.text());
                }
                analyzeRequest.attributes(attributes.toArray(new String[attributes.size()]));
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + (Object)((Object)token) + "] ");
        }
    }

    public static class Fields {
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField TOKENIZER = new ParseField("tokenizer", new String[0]);
        public static final ParseField TOKEN_FILTERS = new ParseField("filter", new String[0]);
        public static final ParseField CHAR_FILTERS = new ParseField("char_filter", new String[0]);
        public static final ParseField EXPLAIN = new ParseField("explain", new String[0]);
        public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
    }
}

