/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Table;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.Streams;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.UTF8StreamWriter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.BytesStream;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.cat.RestTable;

public abstract class AbstractCatAction
extends BaseRestHandler {
    static Set<String> RESPONSE_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("format", "h", "v", "ts", "pri", "bytes", "size", "time", "s")));

    public AbstractCatAction(Settings settings) {
        super(settings);
    }

    protected abstract BaseRestHandler.RestChannelConsumer doCatRequest(RestRequest var1, NodeClient var2);

    protected abstract void documentation(StringBuilder var1);

    protected abstract Table getTableWithHeader(RestRequest var1);

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean helpWanted = request.paramAsBoolean("help", false);
        if (helpWanted) {
            return channel -> {
                Table table = this.getTableWithHeader(request);
                int[] width = RestTable.buildHelpWidths(table, request);
                BytesStream bytesOutput = Streams.flushOnCloseStream(channel.bytesOutput());
                UTF8StreamWriter out = new UTF8StreamWriter().setOutput(bytesOutput);
                for (Table.Cell cell : table.getHeaders()) {
                    RestTable.pad(new Table.Cell(cell.value), width[0], request, out);
                    out.append(" | ");
                    RestTable.pad(new Table.Cell(cell.attr.containsKey("alias") ? cell.attr.get("alias") : ""), width[1], request, out);
                    out.append(" | ");
                    RestTable.pad(new Table.Cell(cell.attr.containsKey("desc") ? cell.attr.get("desc") : "not available"), width[2], request, out);
                    out.append("\n");
                }
                out.close();
                channel.sendResponse(new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", bytesOutput.bytes()));
            };
        }
        return this.doCatRequest(request, client);
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

