/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.CheckedFunction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.NamedRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.ShapesAvailability;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.ShapeBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ParseFieldRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.BoostingQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.CommonTermsQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.ExistsQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.FieldMaskingSpanQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoDistanceRangeQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeohashCellQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.IdsQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.IndicesQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.NestedQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.PrefixQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.RangeQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.RegexpQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.ScriptQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanContainingQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanFirstQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanMultiTermQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanNearQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanNotQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanOrQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanTermQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.SpanWithinQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.TermQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.TermsQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.TypeQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.WildcardQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.WrapperQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.LinearDecayFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.functionscore.WeightBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.SearchPlugin;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchExtBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filters.InternalFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.global.GlobalAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.global.InternalGlobal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.missing.InternalMissing;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.missing.MissingAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.InternalBinaryRange;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.date.DateRangeAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.date.InternalDateRange;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.geodistance.GeoDistanceAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.geodistance.InternalGeoDistance;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.range.ip.IpRangeAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.ChiSquare;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.GND;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.PercentageScore;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.ScriptHeuristic;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.avg.AvgAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.geobounds.GeoBoundsAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.geobounds.InternalGeoBounds;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.geocentroid.GeoCentroidAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.geocentroid.InternalGeoCentroid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.min.InternalMin;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanksAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.hdr.InternalHDRPercentileRanks;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.hdr.InternalHDRPercentiles;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentileRanks;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentiles;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.stats.StatsAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.InternalBucketMetricValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.avg.AvgBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.avg.AvgBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.max.MaxBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.max.MaxBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.min.MinBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.min.MinBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.InternalPercentilesBucket;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.PercentilesBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.InternalStatsBucket;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.StatsBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.StatsBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ExtendedStatsBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.InternalExtendedStatsBucket;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.sum.SumBucketPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.sum.SumBucketPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketselector.BucketSelectorPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.bucketselector.BucketSelectorPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.cumulativesum.CumulativeSumPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.cumulativesum.CumulativeSumPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.derivative.DerivativePipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.derivative.DerivativePipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.derivative.InternalDerivative;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.models.EwmaModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltLinearModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltWintersModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.models.LinearModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.movavg.models.SimpleModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.serialdiff.SerialDiffPipelineAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.serialdiff.SerialDiffPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.DocValueFieldsFetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.ExplainFetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.FetchSourceSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.MatchedQueriesFetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.ParentFieldSubFetchPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.ScriptFieldsFetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.VersionFetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.PostingsHighlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.rescore.QueryRescorerBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.rescore.RescoreBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.ScoreSortBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.ScriptSortBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.SortBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.SuggestionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.phrase.Laplace;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.phrase.LinearInterpolation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.phrase.SmoothingModel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.phrase.StupidBackoff;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class SearchModule {
    public static final Setting<Integer> INDICES_MAX_CLAUSE_COUNT_SETTING = Setting.intSetting("indices.query.bool.max_clause_count", 1024, 1, Integer.MAX_VALUE, Setting.Property.NodeScope);
    private final boolean transportClient;
    private final Map<String, Highlighter> highlighters;
    private final ParseFieldRegistry<SignificanceHeuristicParser> significanceHeuristicParserRegistry = new ParseFieldRegistry("significance_heuristic");
    private final ParseFieldRegistry<MovAvgModel.AbstractModelParser> movingAverageModelParserRegistry = new ParseFieldRegistry("moving_avg_model");
    private final List<FetchSubPhase> fetchSubPhases = new ArrayList<FetchSubPhase>();
    private final Settings settings;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final List<NamedXContentRegistry.Entry> namedXContents = new ArrayList<NamedXContentRegistry.Entry>();

    public SearchModule(Settings settings, boolean transportClient, List<SearchPlugin> plugins) {
        this.settings = settings;
        this.transportClient = transportClient;
        MapperQueryParser.shouldApplyGraphPhraseLimit();
        this.registerSuggesters(plugins);
        this.highlighters = this.setupHighlighters(settings, plugins);
        this.registerScoreFunctions(plugins);
        this.registerQueryParsers(plugins);
        this.registerRescorers();
        this.registerSorts();
        this.registerValueFormats();
        this.registerSignificanceHeuristics(plugins);
        this.registerMovingAverageModels(plugins);
        this.registerAggregations(plugins);
        this.registerPipelineAggregations(plugins);
        this.registerFetchSubPhases(plugins);
        this.registerSearchExts(plugins);
        this.registerShapes();
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContents() {
        return this.namedXContents;
    }

    public Map<String, Highlighter> getHighlighters() {
        return this.highlighters;
    }

    public ParseFieldRegistry<SignificanceHeuristicParser> getSignificanceHeuristicParserRegistry() {
        return this.significanceHeuristicParserRegistry;
    }

    public ParseFieldRegistry<MovAvgModel.AbstractModelParser> getMovingAverageModelParserRegistry() {
        return this.movingAverageModelParserRegistry;
    }

    private void registerAggregations(List<SearchPlugin> plugins) {
        this.registerAggregation(new SearchPlugin.AggregationSpec("avg", AvgAggregationBuilder::new, AvgAggregationBuilder::parse).addResultReader(InternalAvg::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("sum", SumAggregationBuilder::new, SumAggregationBuilder::parse).addResultReader(InternalSum::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("min", MinAggregationBuilder::new, MinAggregationBuilder::parse).addResultReader(InternalMin::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("max", MaxAggregationBuilder::new, MaxAggregationBuilder::parse).addResultReader(InternalMax::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("stats", StatsAggregationBuilder::new, StatsAggregationBuilder::parse).addResultReader(InternalStats::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("extended_stats", ExtendedStatsAggregationBuilder::new, ExtendedStatsAggregationBuilder::parse).addResultReader(InternalExtendedStats::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("value_count", ValueCountAggregationBuilder::new, ValueCountAggregationBuilder::parse).addResultReader(InternalValueCount::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentiles", PercentilesAggregationBuilder::new, PercentilesAggregationBuilder::parse).addResultReader("tdigest_percentiles", InternalTDigestPercentiles::new).addResultReader("hdr_percentiles", InternalHDRPercentiles::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentile_ranks", PercentileRanksAggregationBuilder::new, PercentileRanksAggregationBuilder::parse).addResultReader("tdigest_percentile_ranks", InternalTDigestPercentileRanks::new).addResultReader("hdr_percentile_ranks", InternalHDRPercentileRanks::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("cardinality", CardinalityAggregationBuilder::new, CardinalityAggregationBuilder::parse).addResultReader(InternalCardinality::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("global", GlobalAggregationBuilder::new, GlobalAggregationBuilder::parse).addResultReader(InternalGlobal::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("missing", MissingAggregationBuilder::new, MissingAggregationBuilder::parse).addResultReader(InternalMissing::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("filter", FilterAggregationBuilder::new, FilterAggregationBuilder::parse).addResultReader(InternalFilter::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("filters", FiltersAggregationBuilder::new, FiltersAggregationBuilder::parse).addResultReader(InternalFilters::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("adjacency_matrix", AdjacencyMatrixAggregationBuilder::new, AdjacencyMatrixAggregationBuilder.getParser()).addResultReader(InternalAdjacencyMatrix::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("sampler", SamplerAggregationBuilder::new, SamplerAggregationBuilder::parse).addResultReader("mapped_sampler", InternalSampler::new).addResultReader("unmapped_sampler", UnmappedSampler::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("diversified_sampler", DiversifiedAggregationBuilder::new, DiversifiedAggregationBuilder::parse));
        this.registerAggregation(new SearchPlugin.AggregationSpec("terms", TermsAggregationBuilder::new, TermsAggregationBuilder::parse).addResultReader("sterms", StringTerms::new).addResultReader("umterms", UnmappedTerms::new).addResultReader("lterms", LongTerms::new).addResultReader("dterms", DoubleTerms::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_terms", SignificantTermsAggregationBuilder::new, SignificantTermsAggregationBuilder.getParser(this.significanceHeuristicParserRegistry)).addResultReader("sigsterms", SignificantStringTerms::new).addResultReader("siglterms", SignificantLongTerms::new).addResultReader("umsigterms", UnmappedSignificantTerms::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("range", RangeAggregationBuilder::new, RangeAggregationBuilder::parse).addResultReader(InternalRange::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_range", DateRangeAggregationBuilder::new, DateRangeAggregationBuilder::parse).addResultReader(InternalDateRange::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("ip_range", IpRangeAggregationBuilder::new, IpRangeAggregationBuilder::parse).addResultReader(InternalBinaryRange::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("histogram", HistogramAggregationBuilder::new, HistogramAggregationBuilder::parse).addResultReader(InternalHistogram::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_histogram", DateHistogramAggregationBuilder::new, DateHistogramAggregationBuilder::parse).addResultReader(InternalDateHistogram::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_distance", GeoDistanceAggregationBuilder::new, GeoDistanceAggregationBuilder::parse).addResultReader(InternalGeoDistance::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geohash_grid", GeoGridAggregationBuilder::new, GeoGridAggregationBuilder::parse).addResultReader(InternalGeoHashGrid::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("nested", NestedAggregationBuilder::new, NestedAggregationBuilder::parse).addResultReader(InternalNested::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("reverse_nested", ReverseNestedAggregationBuilder::new, ReverseNestedAggregationBuilder::parse).addResultReader(InternalReverseNested::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("top_hits", TopHitsAggregationBuilder::new, TopHitsAggregationBuilder::parse).addResultReader(InternalTopHits::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_bounds", GeoBoundsAggregationBuilder::new, GeoBoundsAggregationBuilder::parse).addResultReader(InternalGeoBounds::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_centroid", GeoCentroidAggregationBuilder::new, GeoCentroidAggregationBuilder::parse).addResultReader(InternalGeoCentroid::new));
        this.registerAggregation(new SearchPlugin.AggregationSpec("scripted_metric", ScriptedMetricAggregationBuilder::new, ScriptedMetricAggregationBuilder::parse).addResultReader(InternalScriptedMetric::new));
        this.registerFromPlugin(plugins, SearchPlugin::getAggregations, this::registerAggregation);
    }

    private void registerAggregation(SearchPlugin.AggregationSpec spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
                AggregatorFactories.AggParseContext context = (AggregatorFactories.AggParseContext)c;
                return ((Aggregator.Parser)spec.getParser()).parse(context.name, context.queryParseContext);
            }));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(AggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> t : spec.getResultReaders().entrySet()) {
            String writeableName = t.getKey();
            Writeable.Reader<? extends InternalAggregation> internalReader = t.getValue();
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, writeableName, internalReader));
        }
    }

    private void registerPipelineAggregations(List<SearchPlugin> plugins) {
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("derivative", DerivativePipelineAggregationBuilder::new, DerivativePipelineAggregator::new, DerivativePipelineAggregationBuilder::parse).addResultReader(InternalDerivative::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("max_bucket", MaxBucketPipelineAggregationBuilder::new, MaxBucketPipelineAggregator::new, MaxBucketPipelineAggregationBuilder.PARSER).addResultReader("bucket_metric_value", InternalBucketMetricValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("min_bucket", MinBucketPipelineAggregationBuilder::new, MinBucketPipelineAggregator::new, MinBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("avg_bucket", AvgBucketPipelineAggregationBuilder::new, AvgBucketPipelineAggregator::new, AvgBucketPipelineAggregationBuilder.PARSER).addResultReader("simple_value", InternalSimpleValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("sum_bucket", SumBucketPipelineAggregationBuilder::new, SumBucketPipelineAggregator::new, SumBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("stats_bucket", StatsBucketPipelineAggregationBuilder::new, StatsBucketPipelineAggregator::new, StatsBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("extended_stats_bucket", ExtendedStatsBucketPipelineAggregationBuilder::new, ExtendedStatsBucketPipelineAggregator::new, (PipelineAggregator.Parser)new ExtendedStatsBucketParser()).addResultReader(InternalExtendedStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("percentiles_bucket", PercentilesBucketPipelineAggregationBuilder::new, PercentilesBucketPipelineAggregator::new, PercentilesBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalPercentilesBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_avg", MovAvgPipelineAggregationBuilder::new, MovAvgPipelineAggregator::new, (n, c) -> MovAvgPipelineAggregationBuilder.parse(this.movingAverageModelParserRegistry, n, c)));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("cumulative_sum", CumulativeSumPipelineAggregationBuilder::new, CumulativeSumPipelineAggregator::new, CumulativeSumPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_script", BucketScriptPipelineAggregationBuilder::new, BucketScriptPipelineAggregator::new, BucketScriptPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_selector", BucketSelectorPipelineAggregationBuilder::new, BucketSelectorPipelineAggregator::new, BucketSelectorPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("serial_diff", SerialDiffPipelineAggregationBuilder::new, SerialDiffPipelineAggregator::new, SerialDiffPipelineAggregationBuilder::parse));
        this.registerFromPlugin(plugins, SearchPlugin::getPipelineAggregations, this::registerPipelineAggregation);
    }

    private void registerPipelineAggregation(SearchPlugin.PipelineAggregationSpec spec) {
        if (!this.transportClient) {
            this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
                AggregatorFactories.AggParseContext context = (AggregatorFactories.AggParseContext)c;
                return ((PipelineAggregator.Parser)spec.getParser()).parse(context.name, context.queryParseContext);
            }));
        }
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregator.class, spec.getName().getPreferredName(), spec.getAggregatorReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> resultReader : spec.getResultReaders().entrySet()) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, resultReader.getKey(), resultReader.getValue()));
        }
    }

    private void registerShapes() {
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            ShapeBuilders.register(this.namedWriteables);
        }
    }

    private void registerRescorers() {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(RescoreBuilder.class, "query", QueryRescorerBuilder::new));
    }

    private void registerSorts() {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_geo_distance", GeoDistanceSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_score", ScoreSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "_script", ScriptSortBuilder::new));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, "field_sort", FieldSortBuilder::new));
    }

    private <T> void registerFromPlugin(List<SearchPlugin> plugins, Function<SearchPlugin, List<T>> producer, Consumer<T> consumer) {
        for (SearchPlugin plugin : plugins) {
            for (T t : producer.apply(plugin)) {
                consumer.accept(t);
            }
        }
    }

    public static void registerSmoothingModels(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "laplace", Laplace::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "linear", LinearInterpolation::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "stupid_backoff", StupidBackoff::new));
    }

    private void registerSuggesters(List<SearchPlugin> plugins) {
        SearchModule.registerSmoothingModels(this.namedWriteables);
        this.registerSuggester(new SearchPlugin.SuggesterSpec<TermSuggestionBuilder>("term", TermSuggestionBuilder::new, TermSuggestionBuilder::fromXContent));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<PhraseSuggestionBuilder>("phrase", PhraseSuggestionBuilder::new, PhraseSuggestionBuilder::fromXContent));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<CompletionSuggestionBuilder>("completion", CompletionSuggestionBuilder::new, CompletionSuggestionBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getSuggesters, this::registerSuggester);
    }

    private void registerSuggester(SearchPlugin.SuggesterSpec<?> suggester) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SuggestionBuilder.class, suggester.getName().getPreferredName(), suggester.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(SuggestionBuilder.class, suggester.getName(), (CheckedFunction)suggester.getParser()));
    }

    private Map<String, Highlighter> setupHighlighters(Settings settings, List<SearchPlugin> plugins) {
        NamedRegistry<Highlighter> highlighters = new NamedRegistry<Highlighter>("highlighter");
        highlighters.register("fvh", new FastVectorHighlighter(settings));
        highlighters.register("plain", new PlainHighlighter());
        highlighters.register("postings", new PostingsHighlighter());
        highlighters.register("unified", new UnifiedHighlighter());
        highlighters.extractAndRegister(plugins, SearchPlugin::getHighlighters);
        return Collections.unmodifiableMap(highlighters.getRegistry());
    }

    private void registerScoreFunctions(List<SearchPlugin> plugins) {
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ScriptScoreFunctionBuilder>("script_score", ScriptScoreFunctionBuilder::new, ScriptScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<GaussDecayFunctionBuilder>("gauss", GaussDecayFunctionBuilder::new, GaussDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<LinearDecayFunctionBuilder>("linear", LinearDecayFunctionBuilder::new, LinearDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ExponentialDecayFunctionBuilder>("exp", ExponentialDecayFunctionBuilder::new, ExponentialDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<RandomScoreFunctionBuilder>("random_score", RandomScoreFunctionBuilder::new, RandomScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<FieldValueFactorFunctionBuilder>("field_value_factor", FieldValueFactorFunctionBuilder::new, FieldValueFactorFunctionBuilder::fromXContent));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, "weight", WeightBuilder::new));
        this.registerFromPlugin(plugins, SearchPlugin::getScoreFunctions, this::registerScoreFunction);
    }

    private void registerScoreFunction(SearchPlugin.ScoreFunctionSpec<?> scoreFunction) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName().getPreferredName(), scoreFunction.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName(), (p, c) -> ((ScoreFunctionParser)scoreFunction.getParser()).fromXContent((QueryParseContext)c)));
    }

    private void registerValueFormats() {
        this.registerValueFormat(DocValueFormat.BOOLEAN.getWriteableName(), in -> DocValueFormat.BOOLEAN);
        this.registerValueFormat("date_time", DocValueFormat.DateTime::new);
        this.registerValueFormat("decimal", DocValueFormat.Decimal::new);
        this.registerValueFormat(DocValueFormat.GEOHASH.getWriteableName(), in -> DocValueFormat.GEOHASH);
        this.registerValueFormat(DocValueFormat.IP.getWriteableName(), in -> DocValueFormat.IP);
        this.registerValueFormat(DocValueFormat.RAW.getWriteableName(), in -> DocValueFormat.RAW);
    }

    private void registerValueFormat(String name, Writeable.Reader<? extends DocValueFormat> reader) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(DocValueFormat.class, name, reader));
    }

    private void registerSignificanceHeuristics(List<SearchPlugin> plugins) {
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("chi_square", ChiSquare::new, ChiSquare.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("gnd", GND::new, GND.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("jlh", JLHScore::new, JLHScore::parse));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("mutual_information", MutualInformation::new, MutualInformation.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("percentage", PercentageScore::new, PercentageScore::parse));
        this.registerSignificanceHeuristic(new SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser>("script_heuristic", ScriptHeuristic::new, ScriptHeuristic::parse));
        this.registerFromPlugin(plugins, SearchPlugin::getSignificanceHeuristics, this::registerSignificanceHeuristic);
    }

    private void registerSignificanceHeuristic(SearchPlugin.SearchExtensionSpec<SignificanceHeuristic, SignificanceHeuristicParser> heuristic) {
        this.significanceHeuristicParserRegistry.register(heuristic.getParser(), heuristic.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SignificanceHeuristic.class, heuristic.getName().getPreferredName(), heuristic.getReader()));
    }

    private void registerMovingAverageModels(List<SearchPlugin> plugins) {
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("simple", SimpleModel::new, SimpleModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("linear", LinearModel::new, LinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("ewma", EwmaModel::new, EwmaModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt", HoltLinearModel::new, HoltLinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt_winters", HoltWintersModel::new, HoltWintersModel.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getMovingAverageModels, this::registerMovingAverageModel);
    }

    private void registerMovingAverageModel(SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser> movAvgModel) {
        this.movingAverageModelParserRegistry.register(movAvgModel.getParser(), movAvgModel.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(MovAvgModel.class, movAvgModel.getName().getPreferredName(), movAvgModel.getReader()));
    }

    private void registerFetchSubPhases(List<SearchPlugin> plugins) {
        this.registerFetchSubPhase(new ExplainFetchSubPhase());
        this.registerFetchSubPhase(new DocValueFieldsFetchSubPhase());
        this.registerFetchSubPhase(new ScriptFieldsFetchSubPhase());
        this.registerFetchSubPhase(new FetchSourceSubPhase());
        this.registerFetchSubPhase(new VersionFetchSubPhase());
        this.registerFetchSubPhase(new MatchedQueriesFetchSubPhase());
        this.registerFetchSubPhase(new HighlightPhase(this.settings, this.highlighters));
        this.registerFetchSubPhase(new ParentFieldSubFetchPhase());
        SearchPlugin.FetchPhaseConstructionContext context = new SearchPlugin.FetchPhaseConstructionContext(this.highlighters);
        this.registerFromPlugin(plugins, p -> p.getFetchSubPhases(context), this::registerFetchSubPhase);
    }

    private void registerSearchExts(List<SearchPlugin> plugins) {
        this.registerFromPlugin(plugins, SearchPlugin::getSearchExts, this::registerSearchExt);
    }

    private void registerSearchExt(SearchPlugin.SearchExtSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SearchExtBuilder.class, spec.getName(), (CheckedFunction)spec.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SearchExtBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerFetchSubPhase(FetchSubPhase subPhase) {
        Class<?> subPhaseClass = subPhase.getClass();
        if (this.fetchSubPhases.stream().anyMatch(p -> p.getClass().equals(subPhaseClass))) {
            throw new IllegalArgumentException("FetchSubPhase [" + subPhaseClass + "] already registered");
        }
        this.fetchSubPhases.add(Objects.requireNonNull(subPhase, "FetchSubPhase must not be null"));
    }

    private void registerQueryParsers(List<SearchPlugin> plugins) {
        this.registerQuery(new SearchPlugin.QuerySpec<MatchQueryBuilder>(MatchQueryBuilder.QUERY_NAME_FIELD, MatchQueryBuilder::new, MatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhraseQueryBuilder>("match_phrase", MatchPhraseQueryBuilder::new, MatchPhraseQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhrasePrefixQueryBuilder>("match_phrase_prefix", MatchPhrasePrefixQueryBuilder::new, MatchPhrasePrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MultiMatchQueryBuilder>("multi_match", MultiMatchQueryBuilder::new, MultiMatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<NestedQueryBuilder>("nested", NestedQueryBuilder::new, NestedQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DisMaxQueryBuilder>("dis_max", DisMaxQueryBuilder::new, DisMaxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IdsQueryBuilder>("ids", IdsQueryBuilder::new, IdsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchAllQueryBuilder>("match_all", MatchAllQueryBuilder::new, MatchAllQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<QueryStringQueryBuilder>("query_string", QueryStringQueryBuilder::new, QueryStringQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<BoostingQueryBuilder>("boosting", BoostingQueryBuilder::new, BoostingQueryBuilder::fromXContent));
        BooleanQuery.setMaxClauseCount(INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings));
        this.registerQuery(new SearchPlugin.QuerySpec<BoolQueryBuilder>("bool", BoolQueryBuilder::new, BoolQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermQueryBuilder>("term", TermQueryBuilder::new, TermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsQueryBuilder>(TermsQueryBuilder.QUERY_NAME_FIELD, TermsQueryBuilder::new, TermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FuzzyQueryBuilder>("fuzzy", FuzzyQueryBuilder::new, FuzzyQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RegexpQueryBuilder>("regexp", RegexpQueryBuilder::new, RegexpQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RangeQueryBuilder>("range", RangeQueryBuilder::new, RangeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<PrefixQueryBuilder>("prefix", PrefixQueryBuilder::new, PrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WildcardQueryBuilder>("wildcard", WildcardQueryBuilder::new, WildcardQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ConstantScoreQueryBuilder>("constant_score", ConstantScoreQueryBuilder::new, ConstantScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanTermQueryBuilder>("span_term", SpanTermQueryBuilder::new, SpanTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNotQueryBuilder>("span_not", SpanNotQueryBuilder::new, SpanNotQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanWithinQueryBuilder>("span_within", SpanWithinQueryBuilder::new, SpanWithinQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanContainingQueryBuilder>("span_containing", SpanContainingQueryBuilder::new, SpanContainingQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FieldMaskingSpanQueryBuilder>("field_masking_span", FieldMaskingSpanQueryBuilder::new, FieldMaskingSpanQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanFirstQueryBuilder>("span_first", SpanFirstQueryBuilder::new, SpanFirstQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder>("span_near", SpanNearQueryBuilder::new, SpanNearQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanOrQueryBuilder>("span_or", SpanOrQueryBuilder::new, SpanOrQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MoreLikeThisQueryBuilder>(MoreLikeThisQueryBuilder.QUERY_NAME_FIELD, MoreLikeThisQueryBuilder::new, MoreLikeThisQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WrapperQueryBuilder>("wrapper", WrapperQueryBuilder::new, WrapperQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IndicesQueryBuilder>("indices", IndicesQueryBuilder::new, IndicesQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<CommonTermsQueryBuilder>("common", CommonTermsQueryBuilder::new, CommonTermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanMultiTermQueryBuilder>("span_multi", SpanMultiTermQueryBuilder::new, SpanMultiTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FunctionScoreQueryBuilder>("function_score", FunctionScoreQueryBuilder::new, FunctionScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SimpleQueryStringBuilder>("simple_query_string", SimpleQueryStringBuilder::new, SimpleQueryStringBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TypeQueryBuilder>("type", TypeQueryBuilder::new, TypeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptQueryBuilder>("script", ScriptQueryBuilder::new, ScriptQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoDistanceQueryBuilder>("geo_distance", GeoDistanceQueryBuilder::new, GeoDistanceQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoDistanceRangeQueryBuilder>("geo_distance_range", GeoDistanceRangeQueryBuilder::new, GeoDistanceRangeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoBoundingBoxQueryBuilder>(GeoBoundingBoxQueryBuilder.QUERY_NAME_FIELD, GeoBoundingBoxQueryBuilder::new, GeoBoundingBoxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeohashCellQuery.Builder>("geohash_cell", GeohashCellQuery.Builder::new, GeohashCellQuery.Builder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoPolygonQueryBuilder>("geo_polygon", GeoPolygonQueryBuilder::new, GeoPolygonQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ExistsQueryBuilder>("exists", ExistsQueryBuilder::new, ExistsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchNoneQueryBuilder>("match_none", MatchNoneQueryBuilder::new, MatchNoneQueryBuilder::fromXContent));
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.registerQuery(new SearchPlugin.QuerySpec<GeoShapeQueryBuilder>("geo_shape", GeoShapeQueryBuilder::new, GeoShapeQueryBuilder::fromXContent));
        }
        this.registerFromPlugin(plugins, SearchPlugin::getQueries, this::registerQuery);
    }

    private void registerQuery(SearchPlugin.QuerySpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(QueryBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(Optional.class, spec.getName(), (p, c) -> ((QueryParser)spec.getParser()).fromXContent((QueryParseContext)c)));
    }

    public FetchPhase getFetchPhase() {
        return new FetchPhase(this.fetchSubPhases);
    }
}

