/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile.Timer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile.query.ProfileWeight;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private ProfileWeight profileWeight;
    private final Timer scoreTimer;
    private final Timer nextDocTimer;
    private final Timer advanceTimer;
    private final Timer matchTimer;

    ProfileScorer(ProfileWeight w, Scorer scorer, QueryProfileBreakdown profile) throws IOException {
        super(w);
        this.scorer = scorer;
        this.profileWeight = w;
        this.scoreTimer = profile.getTimer(QueryTimingType.SCORE);
        this.nextDocTimer = profile.getTimer(QueryTimingType.NEXT_DOC);
        this.advanceTimer = profile.getTimer(QueryTimingType.ADVANCE);
        this.matchTimer = profile.getTimer(QueryTimingType.MATCH);
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    @Override
    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    @Override
    public int freq() throws IOException {
        return this.scorer.freq();
    }

    @Override
    public Weight getWeight() {
        return this.profileWeight;
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    @Override
    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            @Override
            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            @Override
            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            @Override
            public int docID() {
                return in.docID();
            }

            @Override
            public long cost() {
                return in.cost();
            }
        };
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            @Override
            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            @Override
            public int docID() {
                return inApproximation.docID();
            }

            @Override
            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                ProfileScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.matchTimer.stop();
                }
            }

            @Override
            public float matchCost() {
                return in.matchCost();
            }
        };
    }
}

