/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.transport;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponseHandler;

public class TransportChannelResponseHandler<T extends TransportResponse>
implements TransportResponseHandler<T> {
    private final Logger logger;
    private final TransportChannel channel;
    private final String extraInfoOnError;
    private final Supplier<T> responseSupplier;

    public TransportChannelResponseHandler(Logger logger, TransportChannel channel, String extraInfoOnError, Supplier<T> responseSupplier) {
        this.logger = logger;
        this.channel = channel;
        this.extraInfoOnError = extraInfoOnError;
        this.responseSupplier = responseSupplier;
    }

    @Override
    public T newInstance() {
        return (T)((TransportResponse)this.responseSupplier.get());
    }

    @Override
    public void handleResponse(T response) {
        try {
            this.channel.sendResponse((TransportResponse)response);
        }
        catch (IOException e) {
            this.handleException(new TransportException(e));
        }
    }

    @Override
    public void handleException(TransportException exp) {
        try {
            this.channel.sendResponse(exp);
        }
        catch (IOException e) {
            this.logger.debug(() -> new ParameterizedMessage("failed to send failure {}", (Object)(this.extraInfoOnError == null ? "" : "(" + this.extraInfoOnError + ")")), (Throwable)e);
        }
    }

    @Override
    public String executor() {
        return "same";
    }
}

