/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views.searchtypes.pivot.buckets;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Time;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.graylog.storage.elasticsearch6.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch6.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch6.views.searchtypes.pivot.ESPivotBucketSpecHandler;

public class ESTimeHandler
extends ESPivotBucketSpecHandler<Time, DateHistogramAggregation> {
    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, Time timeSpec, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext, Query query) {
        DateHistogramInterval dateHistogramInterval = new DateHistogramInterval(timeSpec.interval().toDateInterval(query.effectiveTimeRange((SearchType)pivot)).toString());
        Optional<Histogram.Order> ordering = this.orderForPivot(pivot, timeSpec, esGeneratedQueryContext);
        DateHistogramAggregationBuilder builder = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram(name).dateHistogramInterval(dateHistogramInterval).field(timeSpec.field())).order(ordering.orElse(Histogram.Order.KEY_ASC)).format("date_time");
        this.record(esGeneratedQueryContext, pivot, (PivotSpec)timeSpec, name, DateHistogramAggregation.class);
        return Optional.of(builder);
    }

    private Optional<Histogram.Order> orderForPivot(Pivot pivot, Time timeSpec, ESGeneratedQueryContext esGeneratedQueryContext) {
        return pivot.sort().stream().map(sortSpec -> {
            if (sortSpec instanceof PivotSort && timeSpec.field().equals(sortSpec.field())) {
                return sortSpec.direction().equals((Object)SortSpec.Direction.Ascending) ? Histogram.Order.KEY_ASC : Histogram.Order.KEY_DESC;
            }
            if (sortSpec instanceof SeriesSort) {
                Optional<SeriesSpec> matchingSeriesSpec = pivot.series().stream().filter(series -> series.literal().equals(sortSpec.field())).findFirst();
                return matchingSeriesSpec.map(seriesSpec -> {
                    if (seriesSpec.literal().equals("count()")) {
                        return sortSpec.direction().equals((Object)SortSpec.Direction.Ascending) ? Histogram.Order.COUNT_ASC : Histogram.Order.COUNT_DESC;
                    }
                    return Histogram.Order.aggregation(esGeneratedQueryContext.seriesName((SeriesSpec)seriesSpec, pivot), sortSpec.direction().equals((Object)SortSpec.Direction.Ascending));
                }).orElse(null);
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
    }

    @Override
    public Stream<ESPivotBucketSpecHandler.Bucket> doHandleResult(Pivot pivot, Time bucketSpec, SearchResult searchResult, DateHistogramAggregation dateHistogramAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        return dateHistogramAggregation.getBuckets().stream().map(dateHistogram -> ESPivotBucketSpecHandler.Bucket.create(dateHistogram.getTimeAsString(), dateHistogram));
    }
}

