/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.cli;

import org.apiguardian.api.API;
import picocli.CommandLine;
import picocli.CommandLine.Command;
import picocli.CommandLine.HelpCommand;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * Main entrypoint into the reporting CLI
 *
 * @see ConvertCommand
 * @see ValidateCommand
 * @see HtmlReportCommand
 * @since 0.1.0
 */
@Command(//
		name = "open-test-reporting", //
		mixinStandardHelpOptions = true, //
		subcommands = { HelpCommand.class, ConvertCommand.class, ValidateCommand.class, HtmlReportCommand.class } //
)
@API(status = EXPERIMENTAL, since = "0.1.0")
public class ReportingCli {

	private ReportingCli() {
	}

	/**
	 * Run the reporting CLI.
	 *
	 * @param args command-line arguments
	 */
	@SuppressWarnings("InstantiationOfUtilityClass")
	public static void main(String[] args) {
		int exitCode = new CommandLine(new ReportingCli()).execute(args);
		System.exit(exitCode);
	}
}
