/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.core;

import org.apiguardian.api.API;
import org.opentest4j.reporting.events.api.ChildElement;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

import java.time.LocalDateTime;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * The {@code file} element of the core namespace.
 *
 * @since 0.2.0
 */
@API(status = EXPERIMENTAL, since = "0.2.0")
public class File extends ChildElement<Attachments, File> {

	static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_CORE, "file");
	private static final QualifiedName TIME = QualifiedName.of(Namespace.REPORTING_CORE, "time");
	private static final QualifiedName PATH = QualifiedName.of(Namespace.REPORTING_CORE, "path");

	File(Context context) {
		super(context, ELEMENT);
	}

	/**
	 * Set the {@code time} attribute of this element.
	 *
	 * @param timestamp the timestamp to set
	 * @return this element
	 */
	public File withTime(LocalDateTime timestamp) {
		withAttribute(TIME, timestamp.toString());
		return this;
	}

	/**
	 * Set the {@code path} attribute of this element.
	 *
	 * @param path the path to set
	 * @return this element
	 */
	public File withPath(String path) {
		withAttribute(PATH, path);
		return this;
	}
}
