/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.lang.reflect.Method;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import util.exc.TvBrowserException;

public final class ChannelFilter
implements ProgramFilter {
    private ChannelFilterComponent mChannelFilterComponent;

    private ChannelFilter(String name) throws ClassCastException, TvBrowserException {
        this.mChannelFilterComponent = (ChannelFilterComponent)FilterComponentList.getInstance().getFilterComponentByName(name);
        if (this.mChannelFilterComponent == null) {
            throw new TvBrowserException(ChannelFilter.class, "filterComponentNotFound", "Filter component not found");
        }
    }

    public static ChannelFilter createChannelFilterForName(String name) throws ClassCastException, TvBrowserException {
        return new ChannelFilter(name);
    }

    public boolean accept(Program program) {
        return this.mChannelFilterComponent.accept(program);
    }

    public String getName() {
        return this.mChannelFilterComponent.getName();
    }

    public String toString() {
        String result = null;
        try {
            Method m = FilterComponentList.class.getDeclaredMethod("", FilterComponent.class, String.class);
            result = (String)m.invoke(null, this.mChannelFilterComponent, this.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    public Channel[] getChannels() {
        return this.mChannelFilterComponent.getChannels();
    }
}

