/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import javax.swing.SwingUtilities;
import tvbrowser.core.protocolhandler.ProtocolHandler;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.tray.SystemTray;

public final class UdpThread
extends Thread {
    private DatagramSocket mSocket;
    private boolean mRun;
    private byte[] buf = new byte[1024];
    private SystemTray mTray;
    private int mState = 0;

    UdpThread() throws SocketException {
        this.mSocket = new DatagramSocket();
    }

    void initMainFrame() {
        MainFrame.getInstance().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int state = MainFrame.getInstance().getExtendedState();
                if ((state & 6) == 6) {
                    UdpThread.this.mState = 6;
                } else if ((state & 1) != 1) {
                    UdpThread.this.mState = 0;
                }
            }
        });
    }

    void setTray(SystemTray tray) {
        this.mTray = tray;
    }

    @Override
    public synchronized void start() {
        this.setPriority(1);
        this.mRun = true;
        super.start();
    }

    public void halt() {
        if (!this.mSocket.isClosed()) {
            this.mSocket.close();
        }
        this.mRun = false;
    }

    @Override
    public void run() {
        while (this.mRun && !this.mSocket.isClosed()) {
            DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length);
            try {
                this.mSocket.receive(packet);
                InetAddress address = packet.getAddress();
                int port = packet.getPort();
                packet = new DatagramPacket(this.buf, Math.min(this.buf.length, packet.getLength()), address, port);
                String received = new String(packet.getData(), 0, packet.getLength());
                if (!address.equals(InetAddress.getByName("localhost"))) continue;
                if (received.equals("open_tvb")) {
                    if (this.mTray != null && this.mTray.isTrayUsed()) {
                        this.mTray.show();
                        continue;
                    }
                    if ((MainFrame.getInstance().getExtendedState() & 1) == 1) {
                        SwingUtilities.invokeLater(() -> MainFrame.getInstance().showFromTray(this.mState));
                        MainFrame.getInstance().toFront();
                        continue;
                    }
                    MainFrame.getInstance().toFront();
                    continue;
                }
                if (!received.startsWith("tvb://")) continue;
                ProtocolHandler.getInstance().handleMessage(received);
            }
            catch (IOException iOException) {}
        }
        if (!this.mSocket.isClosed()) {
            this.mSocket.close();
        }
    }

    public DatagramSocket getSocket() {
        return this.mSocket;
    }
}

