/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Channel;
import devplugin.PluginAccess;
import devplugin.PluginsProgramFilter;
import devplugin.ProgramFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.JMenu;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.InfoBitFilter;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.PluginFilter;
import tvbrowser.core.filters.SeparatorFilter;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.ui.filter.dlgs.FilterNode;
import tvbrowser.ui.filter.dlgs.FilterTreeModel;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.searchfield.SearchFilter;
import util.i18n.Localizer;
import util.io.stream.BufferedReaderProcessor;
import util.io.stream.StreamUtilities;

public class FilterList {
    private static FilterList INSTANCE;
    private static File mFilterDirectory;
    private File mFilterDat;
    private static final String FILTER_INDEX = "filter.index";
    protected static final String FILTER_DIRECTORY;
    private FilterTreeModel mFilterTreeModel;
    private static final String FILTER_TREE_DAT = "filters.dat";
    private static final Logger LOG;
    private static final Localizer LOCALIZER;

    private FilterList() {
        this.create();
    }

    public static File getFilterDirectory() {
        return mFilterDirectory;
    }

    private void create() {
        mFilterDirectory = new File(FILTER_DIRECTORY);
        this.mFilterDat = new File(mFilterDirectory, FILTER_TREE_DAT);
        if (!mFilterDirectory.exists()) {
            mFilterDirectory.mkdirs();
        }
        this.createFilterList();
    }

    public static synchronized FilterList getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FilterList();
        }
        return INSTANCE;
    }

    private void createFilterList() {
        try {
            PluginFilter pluginFilter;
            ShowAllFilter showAll;
            if (this.mFilterDat.isFile()) {
                try {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.mFilterDat));
                    this.mFilterTreeModel = FilterTreeModel.initInstance(in);
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.mFilterTreeModel == null) {
                this.mFilterTreeModel = FilterTreeModel.initInstance(new ProgramFilter[0]);
            }
            final HashMap<String, UserFilter> filterList = new HashMap<String, UserFilter>();
            if (mFilterDirectory == null) {
                throw new NullPointerException("directory is null");
            }
            File[] fileList = this.getFilterFiles(mFilterDirectory);
            if (fileList != null) {
                for (File file : fileList) {
                    UserFilter filter = null;
                    try {
                        filter = new UserFilter(file);
                    }
                    catch (ParserException e) {
                        LOG.warning("error parsing filter from file " + file + "; exception: " + e);
                    }
                    if (filter == null) continue;
                    filterList.put(filter.getName(), filter);
                }
            }
            try {
                File filterFile = new File(mFilterDirectory, FILTER_INDEX);
                if (filterFile.canRead()) {
                    StreamUtilities.bufferedReader(filterFile, new BufferedReaderProcessor(){

                        @Override
                        public void process(BufferedReader inxIn) throws IOException {
                            String curFilterName = inxIn.readLine();
                            String lastFilterName = null;
                            while (curFilterName != null) {
                                if (curFilterName.equals("[SEPARATOR]")) {
                                    if (lastFilterName == null || !lastFilterName.equals("[SEPARATOR]")) {
                                        FilterList.this.mFilterTreeModel.addFilter(new SeparatorFilter());
                                    }
                                } else {
                                    ProgramFilter filter = (ProgramFilter)filterList.get(curFilterName);
                                    if (filter != null) {
                                        if (!FilterList.this.containsFilter(curFilterName)) {
                                            FilterList.this.mFilterTreeModel.addFilter(filter);
                                        }
                                        filterList.remove(curFilterName);
                                    }
                                }
                                lastFilterName = curFilterName;
                                curFilterName = inxIn.readLine();
                            }
                        }
                    });
                }
            }
            catch (FileNotFoundException filterFile) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (filterList.size() > 0) {
                for (ProgramFilter programFilter : filterList.values()) {
                    if (this.containsFilter(programFilter.getName())) continue;
                    this.mFilterTreeModel.addFilter(programFilter);
                }
            }
            if (!this.containsFilter((showAll = new ShowAllFilter()).getName())) {
                this.mFilterTreeModel.addFilter(showAll);
            }
            if (!this.containsFilter((pluginFilter = new PluginFilter()).getName())) {
                this.mFilterTreeModel.addFilter(pluginFilter);
            }
            String attributesDir = LOCALIZER.msg("ProgramAttributes", "program attributes");
            this.addInfoBitFilter("[SUBTITLE_FILTER]", attributesDir);
            this.addInfoBitFilter("[AUDIO_DESCRIPTION_FILTER]", attributesDir);
            this.addInfoBitFilter("[ORIGINAL_AUDIO_FILTER]", attributesDir);
            this.addInfoBitFilter("[HD_FILTER]", attributesDir);
            this.addInfoBitFilter("[NEW_FILTER]", attributesDir);
            this.addInfoBitFilter("[LIVE_FILTER]", attributesDir);
            String categoriesDir = LOCALIZER.msg("ProgramCategories", "program categories");
            this.addInfoBitFilter("[MOVIE_FILTER]", categoriesDir);
            this.addInfoBitFilter("[SERIES_FILTER]", categoriesDir);
            this.addInfoBitFilter("[SHOW_FILTER]", categoriesDir);
            this.addInfoBitFilter("[DOCUMENTARY_FILTER]", categoriesDir);
            this.addInfoBitFilter("[MAGAZINE_FILTER]", categoriesDir);
            this.addInfoBitFilter("[NEWS_FILTER]", categoriesDir);
            this.addInfoBitFilter("[SPORTS_FILTER]", categoriesDir);
            this.addInfoBitFilter("[ARTS_FILTER]", categoriesDir);
            this.addInfoBitFilter("[CHILDRENS_FILTER]", categoriesDir);
            this.addInfoBitFilter("[OTHERS_FILTER]", categoriesDir);
            this.addInfoBitFilter("[UNCATEGORIZED_FILTER]", categoriesDir);
            this.updateAvailableChannels(ChannelList.getSubscribedChannels());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.mFilterTreeModel.addPluginsProgramFilters();
    }

    private void addInfoBitFilter(String name, String directoryName) {
        FilterNode root = (FilterNode)this.mFilterTreeModel.getRoot();
        FilterNode directoryNode = this.mFilterTreeModel.getDirectoryNode(directoryName, root);
        InfoBitFilter filter = new InfoBitFilter(name);
        if (!this.containsFilter(filter.getName())) {
            if (directoryNode == null) {
                directoryNode = this.mFilterTreeModel.addDirectory(directoryName, root);
            }
            directoryNode.addFilter(filter);
        }
    }

    private File[] getFilterFiles(File directory) {
        return directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getAbsolutePath().endsWith(".filter");
            }
        });
    }

    public void createFilterMenu(JMenu filterMenu, ProgramFilter curFilter) {
        this.mFilterTreeModel.createMenu(filterMenu, curFilter);
    }

    public ProgramFilter[] getFilterArr() {
        ProgramFilter[] mFilterArr = this.mFilterTreeModel.getAllFilters();
        if (SearchFilter.getInstance().isActive()) {
            ProgramFilter[] filter = new ProgramFilter[mFilterArr.length + 1];
            System.arraycopy(mFilterArr, 0, filter, 0, mFilterArr.length);
            filter[mFilterArr.length] = SearchFilter.getInstance();
            return filter;
        }
        return mFilterArr;
    }

    public PluginsProgramFilter[] getPluginsProgramFiltersForPlugin(PluginAccess plugin) {
        ArrayList<PluginsProgramFilter> list = new ArrayList<PluginsProgramFilter>();
        for (ProgramFilter filter : this.mFilterTreeModel.getAllFilters()) {
            if (!(filter instanceof PluginsProgramFilter) || ((PluginsProgramFilter)filter).getPluginAccessOfFilter() == null || !((PluginsProgramFilter)filter).getPluginAccessOfFilter().equals(plugin)) continue;
            list.add((PluginsProgramFilter)filter);
        }
        return list.toArray(new PluginsProgramFilter[list.size()]);
    }

    public UserFilter[] getUserFilterArr() {
        ArrayList<UserFilter> filterList = new ArrayList<UserFilter>();
        for (ProgramFilter filter : this.mFilterTreeModel.getAllFilters()) {
            if (!(filter instanceof UserFilter)) continue;
            filterList.add((UserFilter)filter);
        }
        return filterList.toArray(new UserFilter[filterList.size()]);
    }

    public boolean containsFilter(String filterName) {
        ProgramFilter[] filters = this.mFilterTreeModel.getAllFilters();
        if (filters != null) {
            for (ProgramFilter filter : filters) {
                if (!filter.getName().equalsIgnoreCase(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    public void addProgramFilter(ProgramFilter filter) {
        this.mFilterTreeModel.addFilter(filter);
        this.store();
    }

    public void updateAvailableChannels(Channel[] channels) {
        this.mFilterTreeModel.updateAvailableChannels(channels, LOCALIZER.msg("channelDirectory", "Channel filters"), LOCALIZER.msg("ProgramCategories", "program categories"));
        if (!MainFrame.isStarting()) {
            MainFrame.getInstance().updateFilterMenu();
        }
    }

    public void remove(ProgramFilter filter, boolean pluginCaused) {
        this.mFilterTreeModel.deleteFilter(filter, pluginCaused);
        this.store();
    }

    public void store() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.mFilterDat));
            this.mFilterTreeModel.storeData(out);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File[] fileList = this.getFilterFiles(mFilterDirectory);
        if (fileList != null) {
            for (File file : fileList) {
                file.delete();
            }
        }
        for (ProgramFilter filter : this.mFilterTreeModel.getAllFilters()) {
            if (!(filter instanceof UserFilter)) continue;
            ((UserFilter)filter).store();
        }
    }

    public ProgramFilter getFilterByName(String name) {
        if (name == null) {
            return null;
        }
        for (ProgramFilter filter : this.mFilterTreeModel.getAllFilters()) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    protected ProgramFilter getAllFilter() {
        for (ProgramFilter filter : this.mFilterTreeModel.getAllFilters()) {
            if (!filter.getClass().getName().equals("tvbrowser.core.filters.ShowAllFilter")) continue;
            return filter;
        }
        return new ShowAllFilter();
    }

    protected ProgramFilter getDefaultFilter() {
        try {
            ProgramFilter allFilter = null;
            String filterId = Settings.General.FILTER_DEFAULT.getString();
            String filterName = null;
            if (StringUtils.isNotEmpty((CharSequence)filterId)) {
                String[] filterValues = filterId.split("###");
                filterId = this.shortFilterClassName(filterValues[0]);
                filterName = filterValues[1];
            }
            for (ProgramFilter filter : this.mFilterTreeModel.getAllFilters()) {
                if (filter.getClass().getName().equals("tvbrowser.core.filters.ShowAllFilter")) {
                    allFilter = filter;
                    continue;
                }
                if (filterName == null || !this.shortFilterClassName(filter.getClass().getName()).equals(filterId) || !filter.getName().equals(filterName)) continue;
                return filter;
            }
            if (allFilter != null) {
                return allFilter;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new ShowAllFilter();
    }

    private String shortFilterClassName(String className) {
        int index = className.lastIndexOf(36);
        if (index > 0) {
            return className.substring(0, index);
        }
        return className;
    }

    public FilterTreeModel getFilterTreeModel() {
        return this.mFilterTreeModel;
    }

    static {
        FILTER_DIRECTORY = Settings.getUserSettingsDirName() + "/filters";
        LOG = Logger.getLogger(FilterList.class.getName());
        LOCALIZER = Localizer.getLocalizerFor(FilterList.class);
    }
}

