/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.search.booleansearch;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.search.AbstractSearcher;
import tvbrowser.core.search.booleansearch.AndMatcher;
import tvbrowser.core.search.booleansearch.IMatcher;
import tvbrowser.core.search.booleansearch.NotMatcher;
import tvbrowser.core.search.booleansearch.OperandMatcher;
import tvbrowser.core.search.booleansearch.OrMatcher;
import tvbrowser.core.search.booleansearch.ParserException;
import tvbrowser.core.search.booleansearch.StringMatcher;
import tvbrowser.core.search.booleansearch.StringMatcherRegEx;
import util.i18n.Localizer;

public class BooleanSearcher
extends AbstractSearcher {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(BooleanSearcher.class);
    private IMatcher mRootMatcher;
    private boolean mCaseSensitive;
    private String mPattern;

    @Override
    protected boolean matches(String searchTerm) {
        if (!this.mCaseSensitive) {
            searchTerm = searchTerm.toLowerCase();
        }
        return this.mRootMatcher.matches(searchTerm.replaceAll("\\s+", " "));
    }

    public String toString() {
        return this.mRootMatcher.toString();
    }

    public BooleanSearcher(String pattern, boolean caseSensitive) throws ParserException {
        Hashtable<String, Object> matcherTab = new Hashtable<String, Object>();
        this.mCaseSensitive = caseSensitive;
        this.mPattern = pattern;
        this.mReplaceSpCh = true;
        pattern = ((String)pattern).trim();
        pattern = ((String)pattern).replace(mLocalizer.msg("and", "AND"), "AND").replace(mLocalizer.msg("or", "AND"), "OR").replace(mLocalizer.msg("not", "AND"), "NOT");
        int braceDifference = StringUtils.countMatches((CharSequence)pattern, (CharSequence)"(") - StringUtils.countMatches((CharSequence)pattern, (CharSequence)")");
        if (braceDifference > 0) {
            pattern = (String)pattern + StringUtils.repeat((String)")", (int)braceDifference);
        }
        pattern = ((String)pattern).replaceAll("\\\"", " ");
        pattern = ((String)pattern).replaceAll("\\(", " ( ");
        pattern = ((String)pattern).replaceAll("\\)", " ) ");
        StringTokenizer tokenizer = new StringTokenizer((String)pattern);
        Vector<Object> parts = new Vector<Object>();
        while (tokenizer.hasMoreElements()) {
            String s = tokenizer.nextToken();
            if (s.equals("(")) {
                parts.add(BooleanSearcher.subPart(tokenizer));
                continue;
            }
            parts.add(s);
        }
        this.mRootMatcher = BooleanSearcher.getMatcher(parts, this.mCaseSensitive, matcherTab);
        this.mRootMatcher = this.mRootMatcher.optimize();
    }

    private static Object expect(Vector<Object> part, int index, Class<IMatcher> expectedClass, String expectedName) throws ParserException {
        Object o = part.get(index);
        if (expectedClass.isInstance(o)) {
            return o;
        }
        throw new ParserException(mLocalizer.msg("expectFailed", "Expected {0}, but found '{1}')", expectedName, o.toString()));
    }

    private static IMatcher getMatcher(Vector<Object> part, boolean caseSensitive, Hashtable<String, Object> matcherTable) throws ParserException {
        OperandMatcher a;
        IMatcher O1;
        Object O2;
        Object O;
        int i;
        boolean lastWasMatch = false;
        for (i = 0; i < part.size(); ++i) {
            String s;
            Object o = part.get(i);
            if (o instanceof String && !BooleanSearcher.isKeyWord(s = (String)o)) {
                if (lastWasMatch) {
                    StringMatcherRegEx ME;
                    Object Otemp = part.get(i - 1);
                    if (Otemp instanceof StringMatcher) {
                        ME = new StringMatcherRegEx(((StringMatcher)Otemp).toString(), s, caseSensitive, matcherTable);
                        part.set(i - 1, ME);
                    } else {
                        ME = (StringMatcherRegEx)Otemp;
                        ME.addPart(s);
                    }
                    part.remove(i);
                    --i;
                    continue;
                }
                StringMatcher m = new StringMatcher(s, caseSensitive, matcherTable);
                part.set(i, m);
                lastWasMatch = true;
                continue;
            }
            if (o instanceof Vector && lastWasMatch) {
                part.insertElementAt("AND", i);
                i = 0;
                continue;
            }
            lastWasMatch = false;
        }
        for (i = 0; i < part.size(); ++i) {
            Object O3 = part.get(i);
            if (!(O3 instanceof Vector)) continue;
            Vector v = (Vector)O3;
            part.set(i, BooleanSearcher.getMatcher(v, caseSensitive, matcherTable));
        }
        boolean found = true;
        block2: while (found) {
            found = false;
            for (int i2 = 0; i2 < part.size(); ++i2) {
                O = part.get(i2);
                if (!(O instanceof String) || !O.toString().equals("NOT")) continue;
                if (i2 + 1 >= part.size()) {
                    throw new ParserException(mLocalizer.msg("unexpectedEndOfInput", "Unexpected end of input"));
                }
                O2 = BooleanSearcher.expect(part, i2 + 1, IMatcher.class, mLocalizer.msg("expression", "expression"));
                NotMatcher n = new NotMatcher((IMatcher)O2);
                part.remove(i2);
                part.remove(i2);
                if (!(i2 <= 0 || part.get(i2 - 1) instanceof AndMatcher || part.get(i2 - 1) instanceof String && ((String)part.get(i2 - 1)).equals("AND"))) {
                    part.insertElementAt("AND", i2);
                    ++i2;
                }
                part.insertElementAt(n, i2);
                found = true;
                continue block2;
            }
        }
        found = true;
        block4: while (found) {
            found = false;
            for (int i3 = 0; i3 < part.size(); ++i3) {
                O = part.get(i3);
                if (!(O instanceof String) || !O.toString().equals("AND") && !O.toString().equals("&&")) continue;
                if (i3 <= 0) {
                    throw new ParserException(mLocalizer.msg("missingExprBeforeAND", "Missing expression before 'AND'"));
                }
                if (i3 + 1 >= part.size()) {
                    throw new ParserException(mLocalizer.msg("unexpectedEndOfInput", "Unexpected end of input"));
                }
                O2 = (IMatcher)BooleanSearcher.expect(part, i3 - 1, IMatcher.class, mLocalizer.msg("expression", "expression"));
                O1 = (IMatcher)BooleanSearcher.expect(part, i3 + 1, IMatcher.class, mLocalizer.msg("expression", "expression"));
                a = new AndMatcher(O1, (IMatcher)O2);
                part.remove(i3 - 1);
                part.remove(i3 - 1);
                part.remove(i3 - 1);
                part.insertElementAt(a, i3 - 1);
                found = true;
                continue block4;
            }
        }
        found = true;
        block6: while (found) {
            found = false;
            for (int i4 = 0; i4 < part.size(); ++i4) {
                O = part.get(i4);
                if (!(O instanceof String) || !O.toString().equals("OR") && !O.toString().equals("||")) continue;
                if (i4 <= 0) {
                    throw new ParserException("Missing expression before \"OR\"");
                }
                if (i4 + 1 >= part.size()) {
                    throw new ParserException("Unexpected end of input");
                }
                O2 = (IMatcher)BooleanSearcher.expect(part, i4 - 1, IMatcher.class, mLocalizer.msg("expression", "expression"));
                O1 = (IMatcher)BooleanSearcher.expect(part, i4 + 1, IMatcher.class, mLocalizer.msg("expression", "expression"));
                a = new OrMatcher(O1, (IMatcher)O2);
                part.remove(i4 - 1);
                part.remove(i4 - 1);
                part.remove(i4 - 1);
                part.insertElementAt(a, i4 - 1);
                found = true;
                continue block6;
            }
        }
        return (IMatcher)part.get(0);
    }

    private static boolean isKeyWord(String s) {
        return s.equals("AND") || s.equals("OR") || s.equals("&&") || s.equals("||") || s.equals("NOT");
    }

    private static Vector<Object> subPart(StringTokenizer tokenizer) throws ParserException {
        Vector<Object> v = new Vector<Object>();
        while (tokenizer.hasMoreElements()) {
            String s = tokenizer.nextToken();
            if (s.equals("(")) {
                v.add(BooleanSearcher.subPart(tokenizer));
                continue;
            }
            if (s.equals(")")) {
                return v;
            }
            v.add(s);
        }
        throw new ParserException(mLocalizer.msg("parenthesisExpected", "'(' expected"));
    }

    public String getPattern() {
        return this.mPattern;
    }

    public boolean isCaseSensitive() {
        return this.mCaseSensitive;
    }
}

