/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.ProgramInfoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.filtercomponents.FavoritesFilterComponent;
import tvbrowser.extras.common.LimitationConfiguration;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.misc.TextUtilities;
import util.ui.EnhancedPanelBuilder;
import util.ui.FilterSelectionPanel;
import util.ui.OkayCancelDialog;
import util.ui.SearchableTextAreaPanel;
import util.ui.TimePeriodChooser;
import util.ui.UiUtilities;

public class ExcludeWizardStep
extends AbstractWizardStep {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ExcludeWizardStep.class);
    private static final int MODE_CREATE_DERIVED_FROM_PROGRAM = 0;
    private static final int MODE_CREATE_EXCLUSION = 1;
    private static final int MODE_EDIT_EXCLUSION = 2;
    private Favorite mFavorite;
    private Program mProgram;
    private Exclusion mExclusion;
    private JCheckBox mTitleCb;
    private JCheckBox mTopicCb;
    private JCheckBox mFilterCb;
    private JCheckBox mChannelCb;
    private JCheckBox mTimeCb;
    private JCheckBox mDayCb;
    private JCheckBox mEpisodeTitleCb;
    private JCheckBox mCategoryCb;
    private JCheckBox mProgramFieldCb;
    private JCheckBox mProgramDurationCb;
    private JRadioButton mDurationTooLong;
    private JRadioButton mDurationTooShort;
    private JSpinner mDurationValue;
    private MutliSelectionTextField mTitleTf;
    private MutliSelectionTextField mTopicTf;
    private MutliSelectionTextField mEpisodeTitleTf;
    private MutliSelectionTextField mProgramFieldTextTf;
    private JComboBox<Channel> mChannelCB;
    private JComboBox<LimitationConfiguration.DayLimitValue> mDayChooser;
    private JComboBox<String> mCategoryChooser;
    private JComboBox<ProgramFieldType> mProgramFieldChooser;
    private TimePeriodChooser mTimePeriodChooser;
    private String mMainQuestion;
    private String mChannelQuestion;
    private String mTopicQuestion;
    private String mCateogryQuestion;
    private String mProgramFieldQuestion;
    private String mFilterQuestion;
    private String mTimeQuestion;
    private String mTitleQuestion;
    private String mEpisodeTitleQuestion;
    private String mDayQuestion;
    private String mDurationQuestion;
    private String mDoneBtnText;
    private int mMode;
    private JPanel mContentPanel;
    private FilterSelectionPanel mFilterSelection;

    public ExcludeWizardStep(Favorite favorite) {
        this.init(1, favorite, null, null);
    }

    public ExcludeWizardStep(Favorite favorite, Exclusion exclusion) {
        this.init(2, favorite, null, exclusion);
    }

    public ExcludeWizardStep(Favorite favorite, Program prog) {
        this.init(0, favorite, prog, null);
    }

    private void init(int mode, Favorite favorite, Program prog, Exclusion exclusion) {
        this.mMode = mode;
        this.mFavorite = favorite;
        this.mProgram = prog;
        this.mExclusion = exclusion;
        this.mDoneBtnText = LOCALIZER.msg("doneButton.exclusion", "Create exclusion criteria now");
        if (mode == 1 || mode == 2) {
            this.mMainQuestion = LOCALIZER.msg("mainQuestion.edit", "What programs do you want to exclude?");
            this.mChannelQuestion = LOCALIZER.msg("channelQuestion.edit", "Programs aired on this channel:");
            this.mTopicQuestion = LOCALIZER.msg("topicQuestion.edit", "Programs containing this term:");
            this.mTimeQuestion = LOCALIZER.msg("timeQuestion.edit", "Programs that start during this period:");
            this.mTitleQuestion = LOCALIZER.msg("titleQuestion.edit", "Programs with this title:");
            this.mEpisodeTitleQuestion = LOCALIZER.msg("episodeTitleQuestion.edit", "Program with this episode title:");
            this.mDayQuestion = LOCALIZER.msg("dayOfWeekQuestion.edit", "Programs on this day of week:");
            this.mFilterQuestion = LOCALIZER.msg("filterQuestion.edit", "Programs of the filter:");
            this.mCateogryQuestion = LOCALIZER.msg("categoryQuestion.edit", "Programs with category:");
            this.mProgramFieldQuestion = LOCALIZER.msg("programFieldQuestion.edit", "Programs with:");
            this.mDurationQuestion = LOCALIZER.msg("programDurationQuestion.edit", "Programs with duration:");
        } else {
            this.mMainQuestion = this.mFavorite != null ? LOCALIZER.msg("mainQuestion.create", "Warum gehoert diese Sendung nicht zur Lieblingssendung '{0}'?", this.mFavorite.getName()) : LOCALIZER.msg("mainQuestion.createGlobal", "Why do you want exclude this program?");
            this.mChannelQuestion = LOCALIZER.msg("channelQuestion.create", "Wrong channel:");
            this.mTopicQuestion = LOCALIZER.msg("topicQuestion.create", "Wrong topic:");
            this.mTimeQuestion = LOCALIZER.msg("timeQuestion.create", "Wrong start time:");
            this.mTitleQuestion = LOCALIZER.msg("titleQuestion.create", "Wrong episode title:");
            this.mEpisodeTitleQuestion = LOCALIZER.msg("episodeTitleQuestion.create", "Wrong episode number:");
            this.mDayQuestion = LOCALIZER.msg("dayOfWeekQuestion.create", "Wrong day:");
            this.mCateogryQuestion = LOCALIZER.msg("categoryQuestion.create", "Wrong category:");
            this.mProgramFieldQuestion = LOCALIZER.msg("programFieldQuestion.create", "Wrong:");
            this.mDurationQuestion = LOCALIZER.msg("programDurationQuestion.create", "Wrong duration:");
        }
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Exclude Programs");
    }

    @Override
    public JPanel createContent(final WizardHandler handler) {
        EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("5dlu, default, default, default:grow, 3dlu, default"));
        CaretListener textFieldButtonUpdateListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ExcludeWizardStep.this.updateButtons(handler);
            }
        };
        this.mTitleCb = new JCheckBox(this.mTitleQuestion);
        this.mTitleTf = new MutliSelectionTextField(textFieldButtonUpdateListener);
        this.mTopicTf = new MutliSelectionTextField(textFieldButtonUpdateListener);
        this.mEpisodeTitleTf = new MutliSelectionTextField(textFieldButtonUpdateListener);
        this.mProgramFieldTextTf = new MutliSelectionTextField(textFieldButtonUpdateListener);
        this.mFilterCb = new JCheckBox(this.mFilterQuestion);
        this.mFilterSelection = new FilterSelectionPanel("", null, true, true, FavoriteFilter.class, FavoritesFilterComponent.class);
        this.mDayChooser = new JComboBox<LimitationConfiguration.DayLimitValue>(LimitationConfiguration.DAYLIMIT_VALUE_ARRAY);
        this.mCategoryChooser = new JComboBox<String>(ProgramInfoHelper.getInfoIconMessages());
        this.mChannelCB = new JComboBox<Channel>(ChannelList.getSubscribedChannels());
        panelBuilder.addLabelRowFull(false, this.mMainQuestion);
        panelBuilder.addRow(this.mTitleCb, 2, 2);
        panelBuilder.add(this.mTitleTf.mTextField, 4);
        panelBuilder.add(this.mTitleTf.mButton, 6);
        this.mTopicCb = new JCheckBox(this.mTopicQuestion);
        panelBuilder.addRow(this.mTopicCb, 2, 2);
        panelBuilder.add(this.mTopicTf.mTextField, 4);
        panelBuilder.add(this.mTopicTf.mButton, 6);
        this.mEpisodeTitleCb = new JCheckBox(this.mEpisodeTitleQuestion);
        panelBuilder.addRow(this.mEpisodeTitleCb, 2, 2);
        panelBuilder.add(this.mEpisodeTitleTf.mTextField, 4);
        panelBuilder.add(this.mEpisodeTitleTf.mButton, 6);
        this.mCategoryCb = new JCheckBox(this.mCateogryQuestion);
        panelBuilder.addRow(this.mCategoryCb, 2, 2);
        panelBuilder.add(this.mCategoryChooser, 4, 3);
        if (this.mMode == 2 || this.mMode == 1) {
            panelBuilder.addRow(this.mFilterCb, 2, 2);
            panelBuilder.add(this.mFilterSelection.getFilterBox(), 4);
            panelBuilder.add(this.mFilterSelection.getEditButton(), 6);
        }
        this.mChannelCb = new JCheckBox(this.mChannelQuestion);
        panelBuilder.addRow(this.mChannelCb, 2, 2);
        panelBuilder.add(this.mChannelCB, 4, 3);
        this.mDayCb = new JCheckBox(this.mDayQuestion);
        panelBuilder.addRow(this.mDayCb, 2, 2);
        panelBuilder.add(this.mDayChooser, 4, 3);
        this.mTimeCb = new JCheckBox(this.mTimeQuestion);
        panelBuilder.addRow(this.mTimeCb, 2, 2);
        this.mTimePeriodChooser = new TimePeriodChooser(0);
        panelBuilder.add(this.mTimePeriodChooser, 4, 3);
        this.mProgramFieldCb = new JCheckBox(this.mProgramFieldQuestion);
        panelBuilder.addRow(this.mProgramFieldCb, 2);
        this.mProgramFieldChooser = new JComboBox();
        panelBuilder.add(this.mProgramFieldChooser, 3);
        panelBuilder.add(this.mProgramFieldTextTf.mTextField, 4);
        panelBuilder.add(this.mProgramFieldTextTf.mButton, 6);
        ArrayList<ProgramFieldType> listProgramFields = new ArrayList<ProgramFieldType>();
        listProgramFields.add(ProgramFieldType.AGE_LIMIT_TYPE);
        listProgramFields.add(ProgramFieldType.EPISODE_NUMBER_TYPE);
        listProgramFields.add(ProgramFieldType.GENRE_TYPE);
        listProgramFields.add(ProgramFieldType.LAST_PRODUCTION_YEAR_TYPE);
        listProgramFields.add(ProgramFieldType.ORIGIN_TYPE);
        listProgramFields.add(ProgramFieldType.ORIGINAL_TITLE_TYPE);
        listProgramFields.add(ProgramFieldType.ORIGINAL_EPISODE_TYPE);
        listProgramFields.add(ProgramFieldType.PART_NUMBER_TYPE);
        listProgramFields.add(ProgramFieldType.SERIES_TYPE);
        listProgramFields.add(ProgramFieldType.PRODUCTION_YEAR_TYPE);
        listProgramFields.add(ProgramFieldType.PRODUCTION_COMPANY_TYPE);
        listProgramFields.add(ProgramFieldType.SEASON_NUMBER_TYPE);
        listProgramFields.add(ProgramFieldType.SHORT_DESCRIPTION_TYPE);
        Collections.sort(listProgramFields, ProgramFieldType.getComparatorLocalizedNames());
        for (ProgramFieldType fieldType : listProgramFields) {
            this.mProgramFieldChooser.addItem(fieldType);
        }
        this.mProgramDurationCb = new JCheckBox(this.mDurationQuestion);
        panelBuilder.addRow(this.mProgramDurationCb, 2);
        this.mDurationTooShort = new JRadioButton(LOCALIZER.msg("programDuration.tooShort", "duration to short with:"));
        panelBuilder.add(this.mDurationTooShort, 3);
        this.mDurationTooLong = new JRadioButton(LOCALIZER.msg("programDuration.tooLong", "duration to long with:"));
        panelBuilder.addRow(false, (Component)this.mDurationTooLong, 3);
        JLabel minutes = new JLabel(LOCALIZER.msg("programDuration.minutes", "minutes"));
        JPanel duration = new JPanel((LayoutManager)new FormLayout("default,2dlu,default:grow", "fill:1dlu:grow,default,fill:1dlu:grow"));
        this.mDurationValue = new JSpinner();
        duration.add((Component)this.mDurationValue, CC.xy((int)1, (int)2));
        duration.add((Component)minutes, CC.xy((int)3, (int)2));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mDurationTooShort);
        bg.add(this.mDurationTooLong);
        this.mDurationTooShort.setSelected(true);
        SpinnerNumberModel numberModel = new SpinnerNumberModel(60, 1, 1440, 10);
        this.mDurationValue.setModel(numberModel);
        this.mProgramDurationCb.addItemListener(e -> {
            this.mDurationTooShort.setEnabled(e.getStateChange() == 1);
            this.mDurationTooLong.setEnabled(this.mDurationTooShort.isSelected());
            this.mDurationValue.setEnabled(this.mDurationTooShort.isSelected());
            minutes.setEnabled(this.mDurationTooShort.isSelected());
        });
        this.mDurationTooShort.setEnabled(false);
        this.mDurationTooLong.setEnabled(false);
        this.mDurationValue.setEnabled(false);
        minutes.setEnabled(false);
        panelBuilder.add(duration, CC.xywh((int)4, (int)(panelBuilder.getRowCount() - 1), (int)2, (int)2));
        if (this.mMode == 0 && this.mProgram != null) {
            this.mTitleCb.setSelected(false);
            this.mDoneBtnText = LOCALIZER.msg("doneButton.toBlacklist", "Remove this program now");
            this.mTitleTf.setText(this.mProgram.getTitle());
            String episode = this.mProgram.getTextField(ProgramFieldType.EPISODE_TYPE);
            if (episode != null && episode.trim().length() > 0) {
                this.mEpisodeTitleTf.setText(episode);
            }
            this.mDurationValue.setValue(Math.min(Math.max(1, this.mProgram.getLength()), 1440));
            this.mChannelCB.setSelectedItem(this.mProgram.getChannel());
            int timeFrom = (this.mProgram.getHours() - 1) * 60;
            int timeTo = (this.mProgram.getHours() + 1) * 60;
            if (timeFrom < 0) {
                timeFrom = 0;
            }
            if (timeTo > 1439) {
                timeTo = 1439;
            }
            this.mTimePeriodChooser.setFromTime(timeFrom);
            this.mTimePeriodChooser.setToTime(timeTo);
            this.mDayChooser.setSelectedItem(new LimitationConfiguration.DayLimitValue(this.mProgram.getDate().getCalendar().get(7)));
        } else if (this.mMode == 2) {
            String title = this.mExclusion.getTitle();
            String topic = this.mExclusion.getTopic();
            String episode = this.mExclusion.getEpisodeTitle();
            ProgramFilter filter = this.mExclusion.getFilter();
            Channel channel = this.mExclusion.getChannel();
            int timeFrom = this.mExclusion.getTimeLowerBound();
            int timeTo = this.mExclusion.getTimeUpperBound();
            int dayOfWeek = this.mExclusion.getDayOfWeek();
            int bitIndex = ProgramInfoHelper.getIndexForBit(this.mExclusion.getCategory());
            Exclusion.ProgramFieldExclusion programFieldExclusion = this.mExclusion.getProgramFieldExclusion();
            this.mDurationValue.setValue(Math.max(1, this.mExclusion.getDuration()));
            if (title != null) {
                this.mTitleCb.setSelected(true);
                this.mTitleTf.setText(title);
            }
            if (episode != null) {
                this.mEpisodeTitleCb.setSelected(true);
                this.mEpisodeTitleTf.setText(episode);
            }
            if (topic != null) {
                this.mTopicCb.setSelected(true);
                this.mTopicTf.setText(topic);
            }
            if (filter != null) {
                this.mFilterCb.setSelected(true);
                this.mFilterSelection.setSelectedFilter(filter);
            }
            if (channel != null) {
                this.mChannelCb.setSelected(true);
                this.mChannelCB.setSelectedItem(channel);
            }
            if (timeFrom >= 0 && timeTo >= 0) {
                this.mTimeCb.setSelected(true);
                this.mTimePeriodChooser.setFromTime(timeFrom);
                this.mTimePeriodChooser.setToTime(timeTo);
                this.mDayChooser.setSelectedItem(new LimitationConfiguration.DayLimitValue(this.mExclusion.getDayOfWeek()));
            }
            if (dayOfWeek != -1) {
                this.mDayCb.setSelected(true);
                this.mDayChooser.setSelectedItem(new LimitationConfiguration.DayLimitValue(dayOfWeek));
            }
            if (bitIndex != -1) {
                this.mCategoryCb.setSelected(true);
                this.mCategoryChooser.setSelectedIndex(bitIndex);
            }
            if (programFieldExclusion != null) {
                this.mProgramFieldCb.setSelected(true);
                this.mProgramFieldChooser.setSelectedItem(programFieldExclusion.getProgramFieldType());
                this.mProgramFieldTextTf.setText(programFieldExclusion.getProgramFieldText());
            }
            if (this.mExclusion.getTypeDuration() != 0) {
                this.mProgramDurationCb.setSelected(true);
                switch (this.mExclusion.getTypeDuration()) {
                    case 1: {
                        this.mDurationTooShort.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.mDurationTooShort.setSelected(true);
                    }
                }
            }
        }
        this.updateButtons(handler);
        ItemListener buttonUpdate = e -> {
            if (e.getSource().equals(this.mProgramFieldCb)) {
                this.handleProgramFieldTextSelection(new ItemEvent(this.mProgramFieldChooser, -1, this.mProgramFieldChooser.getSelectedItem(), e.getStateChange()));
            }
            this.updateButtons(handler);
        };
        this.mChannelCb.addItemListener(buttonUpdate);
        this.mTitleCb.addItemListener(buttonUpdate);
        this.mTopicCb.addItemListener(buttonUpdate);
        this.mEpisodeTitleCb.addItemListener(buttonUpdate);
        this.mCategoryCb.addItemListener(buttonUpdate);
        this.mFilterCb.addItemListener(buttonUpdate);
        this.mTimeCb.addItemListener(buttonUpdate);
        this.mDayCb.addItemListener(buttonUpdate);
        this.mProgramFieldCb.addItemListener(buttonUpdate);
        this.mProgramDurationCb.addItemListener(buttonUpdate);
        this.mContentPanel = panelBuilder.getPanel();
        return this.mContentPanel;
    }

    private void updateButtons(WizardHandler handler) {
        boolean allowNext = false;
        if (this.mChannelCb.isSelected()) {
            allowNext = true;
        }
        if (this.mTopicCb.isSelected()) {
            boolean bl = allowNext = allowNext || !this.mTopicTf.getText().trim().isEmpty();
        }
        if (this.mFilterCb.isSelected()) {
            allowNext = true;
        }
        if (this.mTimeCb.isSelected()) {
            allowNext = true;
        }
        if (this.mTitleCb.isSelected()) {
            boolean bl = allowNext = allowNext || !this.mTitleTf.getText().trim().isEmpty();
        }
        if (this.mDayCb.isSelected()) {
            allowNext = true;
        }
        if (this.mEpisodeTitleCb.isSelected()) {
            boolean bl = allowNext = allowNext || !this.mEpisodeTitleTf.getText().trim().isEmpty();
        }
        if (this.mCategoryCb.isSelected()) {
            allowNext = true;
        }
        if (this.mProgramFieldCb.isSelected()) {
            boolean bl = allowNext = allowNext || !this.mProgramFieldTextTf.getText().trim().isEmpty();
        }
        if (this.mProgramDurationCb.isSelected()) {
            boolean bl = allowNext = allowNext || this.mDurationTooShort.isSelected() || this.mDurationTooLong.isSelected();
        }
        if (this.mProgram != null) {
            this.mProgramFieldChooser.addItemListener(e -> this.handleProgramFieldTextSelection(e));
        }
        this.mTitleTf.setEnabled(this.mTitleCb.isSelected());
        this.mChannelCB.setEnabled(this.mChannelCb.isSelected());
        this.mTopicTf.setEnabled(this.mTopicCb.isSelected());
        this.mEpisodeTitleTf.setEnabled(this.mEpisodeTitleCb.isSelected());
        this.mFilterSelection.setEnabled(this.mFilterCb.isSelected());
        this.mTimePeriodChooser.setEnabled(this.mTimeCb.isSelected());
        this.mDayChooser.setEnabled(this.mDayCb.isSelected());
        this.mCategoryChooser.setEnabled(this.mCategoryCb.isSelected());
        this.mProgramFieldChooser.setEnabled(this.mProgramFieldCb.isSelected());
        this.mProgramFieldTextTf.setEnabled(this.mProgramFieldCb.isSelected());
        if (this.mMode == 0 && this.mProgram != null) {
            this.mDoneBtnText = allowNext || this.mFavorite == null ? LOCALIZER.msg("doneButton.exclusion", "Create exclusion criteria now") : LOCALIZER.msg("doneButton.toBlacklist", "Only remove this program now");
            handler.changeDoneBtnText();
            handler.allowFinish(allowNext || this.mFavorite != null);
        } else {
            handler.allowFinish(allowNext);
        }
    }

    private void handleProgramFieldTextSelection(ItemEvent e) {
        if (this.mProgram != null) {
            ProgramFieldType type;
            if (e.getStateChange() == 2 && !this.mProgramFieldTextTf.mTextField.getText().isBlank()) {
                ProgramFieldType type2 = (ProgramFieldType)e.getItem();
                if (this.mProgram.hasFieldValue(type2)) {
                    String text = null;
                    switch (type2.getFormat()) {
                        case 4: {
                            text = this.mProgram.getIntFieldAsString(type2);
                            break;
                        }
                        case 3: {
                            text = this.mProgram.getTextField(type2);
                        }
                    }
                    if (text != null && this.mProgramFieldTextTf.mTextField.getText().equals(text)) {
                        this.mProgramFieldTextTf.mTextField.setText("");
                    }
                }
            } else if (this.mProgramFieldTextTf.mTextField.getText().isBlank() && e.getStateChange() == 1 && this.mProgram.hasFieldValue(type = (ProgramFieldType)e.getItem())) {
                switch (type.getFormat()) {
                    case 4: {
                        this.mProgramFieldTextTf.mTextField.setText(this.mProgram.getIntFieldAsString(type));
                        break;
                    }
                    case 3: {
                        this.mProgramFieldTextTf.mTextField.setText(this.mProgram.getTextField(type));
                    }
                }
            }
        }
    }

    @Override
    public Object createDataObject(Object obj) {
        String title = null;
        String topic = null;
        String episodeTitle = null;
        String filterName = null;
        Channel channel = null;
        int timeFrom = -1;
        int timeTo = -1;
        int weekOfDay = -1;
        int category = 0;
        Exclusion.ProgramFieldExclusion programFieldExclusion = null;
        if (this.mTitleCb.isSelected() && (title = this.mTitleTf.getText().trim()).isEmpty()) {
            title = null;
        }
        if (this.mTopicCb.isSelected() && (topic = this.mTopicTf.getText().trim()).isEmpty()) {
            topic = null;
        }
        if (this.mEpisodeTitleCb.isSelected() && (episodeTitle = this.mEpisodeTitleTf.getText().trim()).isEmpty()) {
            episodeTitle = null;
        }
        if (this.mFilterCb.isSelected()) {
            filterName = this.mFilterSelection.getSelectedFilter().getName();
        }
        if (this.mChannelCb.isSelected()) {
            channel = (Channel)this.mChannelCB.getSelectedItem();
        }
        if (this.mTimeCb.isSelected()) {
            timeFrom = this.mTimePeriodChooser.getFromTime();
            timeTo = this.mTimePeriodChooser.getToTime();
        }
        if (this.mDayCb.isSelected()) {
            weekOfDay = ((LimitationConfiguration.DayLimitValue)this.mDayChooser.getSelectedItem()).getDay();
        }
        if (this.mCategoryCb.isSelected()) {
            category = ProgramInfoHelper.getBitForIndex(this.mCategoryChooser.getSelectedIndex());
        }
        if (this.mProgramFieldCb.isSelected() && !this.mProgramFieldTextTf.getText().trim().isEmpty()) {
            programFieldExclusion = new Exclusion.ProgramFieldExclusion(((ProgramFieldType)this.mProgramFieldChooser.getSelectedItem()).getTypeId(), this.mProgramFieldTextTf.getText());
        }
        int typeDuration = 0;
        if (this.mProgramDurationCb.isSelected()) {
            if (this.mDurationTooShort.isSelected()) {
                typeDuration = 1;
            } else if (this.mDurationTooLong.isSelected()) {
                typeDuration = 2;
            }
        }
        if (this.mDoneBtnText.compareTo(LOCALIZER.msg("doneButton.toBlacklist", "Remove this program now")) == 0) {
            return "blacklist";
        }
        return new Exclusion(title, topic, channel, timeFrom, timeTo, weekOfDay, filterName, episodeTitle, category, programFieldExclusion, typeDuration, (Integer)this.mDurationValue.getValue());
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4};
    }

    @Override
    public WizardStep next() {
        return null;
    }

    @Override
    public WizardStep back() {
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isSingleStep() {
        return true;
    }

    @Override
    public String getDoneBtnText() {
        return this.mDoneBtnText;
    }

    private static final class MutliSelectionTextField {
        private static final String SEPARATOR = ";;";
        private JTextField mTextField;
        private JButton mButton;

        private MutliSelectionTextField(CaretListener listener) {
            this("", listener);
        }

        private MutliSelectionTextField(String text, CaretListener listener) {
            this.mTextField = new JTextField(text);
            this.mTextField.addCaretListener(listener);
            this.mButton = new JButton(LOCALIZER.ellipsisMsg("multiple.select", "Multiple"));
            this.mButton.addActionListener(e -> {
                SearchableTextAreaPanel area = new SearchableTextAreaPanel(this.mTextField.getText(), SEPARATOR, false);
                Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                OkayCancelDialog dlg = new OkayCancelDialog(parent, LOCALIZER.msg("multiple.title", "Enter data"), area, LOCALIZER.msg("multiple.help", "Use one line for each entry."), !this.mTextField.getText().isBlank());
                area.getTextArea().addCaretListener(ce -> dlg.setOkayEnabled(!area.getText().isBlank()));
                Settings.layoutWindow("excludeWizardMultipleInput2", dlg, new Dimension(500, 400), parent);
                dlg.setVisible(true);
                if (dlg.getOkWasPressed()) {
                    this.mTextField.setText(area.getText(SEPARATOR));
                    this.mTextField.setCaretPosition(0);
                }
            });
        }

        private void setEnabled(boolean enabled) {
            this.mTextField.setEnabled(enabled);
            this.mButton.setEnabled(enabled);
        }

        private void setText(String text) {
            this.mTextField.setText(text);
        }

        private String getText() {
            return TextUtilities.removeDoubletLines(this.mTextField.getText(), SEPARATOR, SEPARATOR);
        }
    }
}

