/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.extras.favoritesplugin.core.ActorsFavorite;
import tvbrowser.extras.favoritesplugin.core.AdvancedFavorite;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FilterFavorite;
import tvbrowser.extras.favoritesplugin.core.TitleFavorite;
import tvbrowser.extras.favoritesplugin.core.TopicFavorite;
import tvbrowser.extras.favoritesplugin.dlgs.EditFavoriteDialog;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.NotificationWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.program.ProgramUtilities;
import util.ui.EnhancedPanelBuilder;
import util.ui.LinkButton;
import util.ui.UiUtilities;

public class TypeWizardStep
extends AbstractWizardStep {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(TypeWizardStep.class);
    private JTextField mProgramNameTf;
    private JTextField mTopicTf;
    private JComboBox<String> mActorsCb;
    private JRadioButton mTitleRb;
    private JRadioButton mTopicRb;
    private JRadioButton mActorsRb;
    private JPanel mContent;
    private Program mProgram;
    private String mMainQuestion;
    private String mActor;
    private boolean mAdvancedSelected = false;
    private String mTopic;
    private Favorite mFavorite;

    public TypeWizardStep() {
        this(null);
    }

    public TypeWizardStep(Program program) {
        this(program, (FavoriteNode)FavoriteTreeModel.getInstance().getRoot());
    }

    public TypeWizardStep(Program program, FavoriteNode parent) {
        this.mProgram = program;
        this.mMainQuestion = this.mProgram == null ? LOCALIZER.msg("mainQuestion.create", "Choose the condition that your favorite program needs to match:") : LOCALIZER.msg("mainQuestion.edit", "Why is this program a favorite of yours?");
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Create new Favorite");
    }

    @Override
    public JPanel createContent(WizardHandler handler) {
        LinkButton expertBtn = new LinkButton(LOCALIZER.msg("advancedView", "Switch to expert view"), null);
        LinkButton filterBtn = new LinkButton(LOCALIZER.msg("filterFavorite", "Create filter favorite"), null);
        EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("5dlu, pref, default:grow"));
        panelBuilder.addLabelRowFull(false, this.mMainQuestion);
        this.mTitleRb = new JRadioButton(LOCALIZER.msg("option.title", "I like this program:"));
        panelBuilder.addRow(this.mTitleRb, 2);
        this.mProgramNameTf = new JTextField();
        panelBuilder.add(this.mProgramNameTf, 3);
        this.mTopicRb = new JRadioButton(LOCALIZER.msg("option.topic", "I like this subject:"));
        panelBuilder.addRow(this.mTopicRb, 2);
        this.mTopicTf = new JTextField();
        panelBuilder.add(this.mTopicTf, 3);
        this.mActorsRb = new JRadioButton(LOCALIZER.msg("option.actors", "I like these actors:"));
        panelBuilder.addRow(this.mActorsRb, 2);
        this.mActorsCb = new JComboBox();
        this.mActorsCb.setEditable(true);
        panelBuilder.add(this.mActorsCb, 3);
        panelBuilder.border(Borders.DLU4);
        panelBuilder.addRowFull(expertBtn);
        panelBuilder.addRowFull(filterBtn);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mTitleRb);
        group.add(this.mTopicRb);
        group.add(this.mActorsRb);
        this.mTitleRb.setSelected(true);
        this.updateTextfields();
        this.mTitleRb.addActionListener(e -> this.updateTextfields());
        this.mTopicRb.addActionListener(e -> this.updateTextfields());
        this.mActorsRb.addActionListener(e -> this.updateTextfields());
        expertBtn.addActionListener(e -> {
            this.mAdvancedSelected = true;
            String title = this.mProgram != null ? this.mProgram.getTitle() : "";
            this.mFavorite = new AdvancedFavorite(title);
            Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            EditFavoriteDialog dlg = new EditFavoriteDialog(parent, this.mFavorite);
            UiUtilities.centerAndShow(dlg);
            if (!dlg.getOkWasPressed()) {
                this.mFavorite = null;
            }
            handler.finishWithCurrentStep();
        });
        filterBtn.addActionListener(e -> {
            this.mAdvancedSelected = true;
            this.mFavorite = new FilterFavorite();
            Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            EditFavoriteDialog dlg = new EditFavoriteDialog(parent, this.mFavorite);
            UiUtilities.centerAndShow(dlg);
            if (!dlg.getOkWasPressed()) {
                this.mFavorite = null;
            }
            handler.finishWithCurrentStep();
        });
        if (this.mProgram != null) {
            this.mProgramNameTf.setText(this.mProgram.getTitle());
            String[] actors = ProgramUtilities.getActorNames(this.mProgram);
            if (actors != null) {
                for (String actor : actors) {
                    this.mActorsCb.addItem(actor);
                }
            }
        }
        this.mContent = panelBuilder.getPanel();
        this.mContent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TypeWizardStep.this.handleFocusEvent();
            }
        });
        this.mContent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TypeWizardStep.this.handleFocusEvent();
            }
        });
        if (this.mTopic != null) {
            this.mTopicRb.setSelected(true);
            this.updateTextfields();
            this.mTopicTf.setText(this.mTopic);
            if (this.mActor == null && ProgramUtilities.getActorNames(this.mProgram) == null) {
                this.mActorsCb.setSelectedItem(this.mTopic);
            }
        } else if (this.mActor != null) {
            this.mActorsRb.setSelected(true);
            this.updateTextfields();
            this.mActorsCb.setSelectedItem(this.mActor);
        }
        return this.mContent;
    }

    private void handleFocusEvent() {
        if (this.mProgramNameTf.isEnabled()) {
            this.mProgramNameTf.requestFocusInWindow();
        } else if (this.mTopicTf.isEnabled()) {
            this.mTopicTf.requestFocusInWindow();
        } else if (this.mActorsCb.isEnabled()) {
            this.mActorsCb.requestFocusInWindow();
        }
    }

    protected void updateTextfields() {
        this.mProgramNameTf.setEnabled(this.mTitleRb.isSelected());
        this.mTopicTf.setEnabled(this.mTopicRb.isSelected());
        this.mActorsCb.setEnabled(this.mActorsRb.isSelected());
        this.handleFocusEvent();
    }

    private Favorite createFavorite() {
        String actors;
        if (this.mFavorite != null || this.mAdvancedSelected) {
            return this.mFavorite;
        }
        if (this.mTitleRb.isSelected()) {
            String title = this.mProgramNameTf.getText();
            if (title != null && title.length() > 0) {
                return new TitleFavorite(title);
            }
        } else if (this.mTopicRb.isSelected()) {
            String topic = this.mTopicTf.getText();
            if (topic != null && topic.length() > 0) {
                return new TopicFavorite(topic);
            }
        } else if (this.mActorsRb.isSelected() && (actors = (String)this.mActorsCb.getSelectedItem()) != null && actors.trim().length() > 0) {
            return new ActorsFavorite(actors);
        }
        return null;
    }

    @Override
    public Object createDataObject(Object obj) {
        return this.createFavorite();
    }

    @Override
    public WizardStep next() {
        return new NotificationWizardStep(this, this.mProgram);
    }

    @Override
    public WizardStep back() {
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.mTitleRb.isSelected()) {
            String title = this.mProgramNameTf.getText();
            if (title != null && title.trim().length() > 0) {
                return true;
            }
            JOptionPane.showMessageDialog(this.mContent, LOCALIZER.msg("warningTitleMessage", "Enter Title!"), LOCALIZER.msg("warningTitleTitle", "Enter Title"), 2);
            this.mProgramNameTf.requestFocusInWindow();
        } else if (this.mTopicRb.isSelected()) {
            String topic = this.mTopicTf.getText();
            if (topic != null && topic.trim().length() > 0) {
                return true;
            }
            JOptionPane.showMessageDialog(this.mContent, LOCALIZER.msg("warningTopicMessage", "Enter Topic!"), LOCALIZER.msg("warningTopicTitle", "Enter Topic"), 2);
            this.mTopicTf.requestFocusInWindow();
        } else if (this.mActorsRb.isSelected()) {
            String actor = (String)this.mActorsCb.getSelectedItem();
            if (actor != null && actor.trim().length() > 0) {
                return true;
            }
            JOptionPane.showMessageDialog(this.mContent, LOCALIZER.msg("warningActorsMessage", "Enter Actors!"), LOCALIZER.msg("warningActorsTitle", "Enter Actors"), 2);
            this.mActorsCb.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4, 1};
    }

    public void setActor(String actor) {
        if (StringUtils.isBlank((CharSequence)actor)) {
            return;
        }
        this.mActor = actor;
    }

    public void setTopic(String topic) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            return;
        }
        this.mTopic = topic;
    }
}

