/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import util.ui.ImageUtilities;

public class SkinPanel
extends JPanel {
    private Image image;
    private int hImg;
    private int wImg;
    private int mode = 1;
    private String imgFile;
    private int colDiff = 0;
    private int rowDiff = 0;
    public static final int NONE = 0;
    public static final int WALLPAPER = 1;
    public static final int COLUMNS = 2;
    public static final int ROWS = 3;
    public static final int SINGLE = 4;

    public SkinPanel() {
    }

    public SkinPanel(String imgFile, int mode) {
        this.mode = mode;
        this.imgFile = imgFile;
        if (mode != 0) {
            File f = new File(imgFile);
            if (f.exists() && f.isFile()) {
                this.image = new ImageIcon(imgFile).getImage();
                this.setSkin(this.image);
            } else {
                this.image = null;
            }
        }
    }

    public void setColDiff(int diff) {
        this.colDiff = diff;
    }

    public void setRowDiff(int diff) {
        this.rowDiff = diff;
    }

    public void update(String newImgFile, int newMode) {
        if (this.mode != newMode || !newImgFile.equals(this.imgFile)) {
            this.imgFile = newImgFile;
            this.mode = newMode;
            File f = new File(this.imgFile);
            if (f.exists() && f.isFile()) {
                this.image = ImageUtilities.createImage(this.imgFile);
                this.setSkin(this.image);
            } else {
                this.image = null;
            }
            this.repaint();
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setSkin(Image img) {
        this.image = img;
        if (this.image != null) {
            this.hImg = this.image.getHeight(this);
            this.wImg = this.image.getWidth(this);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.image == null || this.mode == 0) {
            super.paintComponent(g);
            return;
        }
        super.paintComponent(g);
        if (this.mode == 4) {
            g.drawImage(this.image, 0, 0, this);
        } else {
            int width = this.getWidth();
            int height = this.getHeight();
            int stepX = 0;
            int stepY = 0;
            if (this.mode == 1) {
                stepX = this.wImg;
                stepY = this.hImg;
            } else if (this.mode == 2) {
                stepX = this.colDiff;
                stepY = this.hImg;
            } else if (this.mode == 3) {
                stepX = this.wImg;
                stepY = this.rowDiff;
            }
            if (stepX == 0 || stepY == 0) {
                throw new RuntimeException();
            }
            for (int x = 0; x < width; x += stepX) {
                for (int y = 0; y < height; y += stepY) {
                    g.drawImage(this.image, x, y, this);
                }
            }
        }
    }
}

