/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.ui.configassistant.AuthenticationChannelCardPanel;
import tvbrowser.ui.configassistant.CardPanel;
import tvbrowser.ui.configassistant.FinishCardPanel;
import tvbrowser.ui.configassistant.NetworkCardPanel;
import tvbrowser.ui.configassistant.NetworkSuccessPanel;
import tvbrowser.ui.configassistant.PrevNextButtons;
import tvbrowser.ui.configassistant.SubscribeChannelCardPanel;
import tvbrowser.ui.configassistant.WelcomeCardPanel;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ConfigAssistant
extends JDialog
implements ActionListener,
PrevNextButtons,
WindowClosingIf {
    private JButton mNextBt;
    private JButton mBackBt;
    private JButton mCancelBt;
    private transient CardPanel mCurCardPanel;
    private transient CardPanel mFinishedPanel;
    private JPanel mCardPn;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ConfigAssistant.class);

    public ConfigAssistant(JFrame parent) {
        super((Frame)parent, true);
        UiUtilities.registerForClosing(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfigAssistant.this.close();
            }
        });
        File tvDataDir = new File(Settings.Directories.TV_DATA.getString().trim());
        Settings.Directories.TV_DATA.setString(tvDataDir.toString().replaceAll("\\\\", "/"));
        TvDataServiceProxyManager.getInstance().setTvDataDir(tvDataDir);
        this.setTitle(mLocalizer.msg("title", "Setup assistant"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout((LayoutManager)new FormLayout("fill:250px:grow", "fill:50dlu:grow, 1px, pref"));
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.mCardPn = new JPanel(new CardLayout());
        this.mBackBt = new JButton("<< " + Localizer.getLocalization("i18n_back"));
        this.mNextBt = new JButton(Localizer.getLocalization("i18n_next") + " >>");
        this.mCancelBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mBackBt.setEnabled(false);
        this.mBackBt.addActionListener(this);
        this.mNextBt.addActionListener(this);
        this.mCancelBt.addActionListener(this);
        WelcomeCardPanel welcomePanel = new WelcomeCardPanel(this);
        NetworkCardPanel networkPanel = new NetworkCardPanel(this);
        AuthenticationChannelCardPanel authenticationChannelCardPanel = new AuthenticationChannelCardPanel(this);
        SubscribeChannelCardPanel subscribeChannelPanel = new SubscribeChannelCardPanel(this);
        NetworkSuccessPanel networkSuccessPanel = new NetworkSuccessPanel(this, this.mCardPn, authenticationChannelCardPanel, subscribeChannelPanel);
        this.mFinishedPanel = new FinishCardPanel(this);
        this.mCardPn.add((Component)welcomePanel.getPanel(), welcomePanel.toString());
        this.mCardPn.add((Component)networkPanel.getPanel(), networkPanel.toString());
        this.mCardPn.add((Component)networkSuccessPanel.getPanel(), networkSuccessPanel.toString());
        this.mCardPn.add((Component)this.mFinishedPanel.getPanel(), this.mFinishedPanel.toString());
        this.mCardPn.add((Component)subscribeChannelPanel.getPanel(), subscribeChannelPanel.toString());
        boolean dynamicChannelList = this.isDynamicChannelListSupported();
        welcomePanel.setNext(networkPanel);
        if (dynamicChannelList) {
            networkPanel.setNext(networkSuccessPanel);
            networkSuccessPanel.setNext(subscribeChannelPanel);
            subscribeChannelPanel.setPrev(networkSuccessPanel);
            subscribeChannelPanel.setNext(this.mFinishedPanel);
            this.mFinishedPanel.setPrev(subscribeChannelPanel);
        } else {
            networkPanel.setNext(networkSuccessPanel);
            networkSuccessPanel.setNext(subscribeChannelPanel);
            subscribeChannelPanel.setNext(this.mFinishedPanel);
            this.mFinishedPanel.setPrev(subscribeChannelPanel);
        }
        this.mCurCardPanel = welcomePanel;
        FormLayout layout = new FormLayout("fill:0dlu:grow, pref, 3dlu, pref, 3dlu, pref", "pref");
        layout.setColumnGroups((int[][])new int[][]{{2, 4, 6}});
        JPanel buttonPanel = new JPanel((LayoutManager)layout);
        buttonPanel.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        buttonPanel.add((Component)this.mBackBt, cc.xy(2, 1));
        buttonPanel.add((Component)this.mNextBt, cc.xy(4, 1));
        buttonPanel.add((Component)this.mCancelBt, cc.xy(6, 1));
        centerPanel.add((Component)this.mCardPn, "Center");
        contentPane.add((Component)centerPanel, cc.xy(1, 1));
        JPanel black = new JPanel();
        black.setBackground(this.mCancelBt.getForeground());
        contentPane.add((Component)black, cc.xy(1, 2));
        contentPane.add((Component)buttonPanel, cc.xy(1, 3));
        this.setSize(Sizes.dialogUnitXAsPixel((int)500, (Component)this), Sizes.dialogUnitYAsPixel((int)320, (Component)this));
    }

    private boolean isDynamicChannelListSupported() {
        TvDataServiceProxy[] services;
        for (TvDataServiceProxy service : services = TvDataServiceProxyManager.getInstance().getDataServices()) {
            if (!service.supportsDynamicChannelList()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(() -> {
            boolean next = this.mNextBt.isEnabled();
            boolean back = this.mBackBt.isEnabled();
            boolean cancel = this.mCancelBt.isEnabled();
            this.mNextBt.setEnabled(false);
            this.mBackBt.setEnabled(false);
            this.mCancelBt.setEnabled(false);
            Object o = e.getSource();
            if (o == this.mBackBt) {
                if (this.mCurCardPanel == this.mFinishedPanel) {
                    this.mCancelBt.setVisible(true);
                    this.mNextBt.setText(Localizer.getLocalization("i18n_next") + " >>");
                }
                if (!this.mCurCardPanel.onPrev()) {
                    this.mNextBt.setEnabled(next);
                    this.mBackBt.setEnabled(back);
                    this.mCancelBt.setEnabled(cancel);
                    return;
                }
                this.mCurCardPanel = this.mCurCardPanel.getPrev();
                CardLayout cl1 = (CardLayout)this.mCardPn.getLayout();
                this.mCurCardPanel.onShow();
                cl1.show(this.mCardPn, this.mCurCardPanel.toString());
                this.mCancelBt.setEnabled(true);
            } else if (o == this.mNextBt) {
                if (this.mCurCardPanel == this.mFinishedPanel) {
                    Settings.Window.ASSISTANT_SHOW.setBoolean(false);
                    this.setVisible(false);
                } else {
                    if (!this.mCurCardPanel.onNext()) {
                        this.mNextBt.setEnabled(next);
                        this.mBackBt.setEnabled(back);
                        this.mCancelBt.setEnabled(cancel);
                        return;
                    }
                    this.mCurCardPanel = this.mCurCardPanel.getNext();
                    CardLayout cl2 = (CardLayout)this.mCardPn.getLayout();
                    this.mCurCardPanel.onShow();
                    cl2.show(this.mCardPn, this.mCurCardPanel.toString());
                    this.mCancelBt.setEnabled(true);
                    if (this.mCurCardPanel == this.mFinishedPanel) {
                        this.mCancelBt.setVisible(false);
                        this.mNextBt.setText(mLocalizer.msg("finish", "Finish"));
                        this.mNextBt.setEnabled(true);
                        this.mBackBt.setEnabled(true);
                    }
                }
            } else if (o == this.mCancelBt) {
                this.cancel();
                this.mNextBt.setEnabled(next);
                this.mBackBt.setEnabled(back);
                this.mCancelBt.setEnabled(cancel);
            }
        }).start();
    }

    private void cancel() {
        JCheckBox notShowAgain = new JCheckBox(mLocalizer.msg("notShowAgain", "Don't show assistant again."));
        notShowAgain.setSelected(!Settings.Window.ASSISTANT_SHOW.getBoolean());
        Object[] values = new Object[]{mLocalizer.msg("cancelDlg", "message"), notShowAgain};
        Object[] buttons = new Object[]{mLocalizer.msg("button.1", "Close assistant"), mLocalizer.msg("button.2", "Continue configuration")};
        int selectedValue = JOptionPane.showOptionDialog(this, values, mLocalizer.msg("cancelDlg.title", "title"), 2, 2, null, buttons, buttons[1]);
        if (selectedValue == 0) {
            Settings.Window.ASSISTANT_SHOW.setBoolean(!notShowAgain.isSelected());
            this.setVisible(false);
        }
    }

    @Override
    public void enablePrevButton() {
        this.mBackBt.setEnabled(true);
    }

    @Override
    public void enableNextButton() {
        this.mNextBt.setEnabled(true);
    }

    @Override
    public void disablePrevButton() {
        this.mBackBt.setEnabled(false);
    }

    @Override
    public void disableNextButton() {
        this.mNextBt.setEnabled(false);
    }

    @Override
    public void close() {
        if (this.mCurCardPanel == this.mFinishedPanel) {
            Settings.Window.ASSISTANT_SHOW.setBoolean(false);
            this.setVisible(false);
        } else {
            this.cancel();
        }
    }
}

