/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramFilter;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import util.ui.DefaultMarkingPrioritySelectionPanel;

public class FilterHighlightingSelectionPanel
extends JPanel {
    private DefaultMarkingPrioritySelectionPanel mFilterHighlight;
    private DefaultMarkingPrioritySelectionPanel.State mState;
    private int mPriorityInitial;

    public FilterHighlightingSelectionPanel(ProgramFilter filter) {
        this.mState = new DefaultMarkingPrioritySelectionPanel.State("selectable", filter != null && Settings.Markings.HIGHLIGHTING_FILTERS.containsKey(filter.getName()));
        this.mPriorityInitial = Settings.Markings.MARK_PRIORITY_FILTERS.getInt();
        if (this.mState.isActivated()) {
            try {
                this.mPriorityInitial = Integer.parseInt(Settings.Markings.HIGHLIGHTING_FILTERS.getEntry(filter.getName()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.mFilterHighlight = DefaultMarkingPrioritySelectionPanel.createPanel(this.mState, this.mPriorityInitial, EditFilterDlg.LOCALIZER.msg("highlight", "Highlight all matching programs"), false, false, false, true, false);
        this.setOpaque(false);
        this.setLayout((LayoutManager)new FormLayout("default:grow", "default"));
        this.add((Component)this.mFilterHighlight, CC.xy((int)1, (int)1));
    }

    public DefaultMarkingPrioritySelectionPanel.State getState() {
        return this.mState;
    }

    public int getSelectedPriority() {
        return this.mFilterHighlight.getSelectedPriority();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mFilterHighlight.setEnabled(enabled);
    }

    public void save(ProgramFilter filter) {
        if (this.getState().isActivated()) {
            Settings.Markings.HIGHLIGHTING_FILTERS.putEntry(filter.getName(), this.mFilterHighlight.getSelectedPriority());
        } else {
            Settings.Markings.HIGHLIGHTING_FILTERS.removeEntry(filter.getName());
        }
    }

    public boolean wasChanged() {
        return this.mPriorityInitial != this.getSelectedPriority() || this.mState.wasChanged();
    }
}

