/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import devplugin.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginBaseInfo;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.ui.update.DataServiceSoftwareUpdateItem;
import tvbrowser.ui.update.PluginSoftwareUpdateItem;
import tvbrowser.ui.update.PluginsSoftwareUpdateItem;
import tvbrowser.ui.update.SoftwareUpdateItem;
import tvbrowser.ui.update.TvbrowserSoftwareUpdateItem;
import util.io.IOUtilities;

public final class SoftwareUpdater {
    public static final int ALL_TYPE = 0;
    public static final int ONLY_UPDATE_TYPE = 1;
    public static final int ONLY_DATA_SERVICE_TYPE = 2;
    public static final int DRAG_AND_DROP_TYPE = 3;
    private SoftwareUpdateItem[] mSoftwareUpdateItems;
    private String mBlockRequestingPluginId;
    private boolean mIsRequestingBlockArrayClear;
    private TvbrowserSoftwareUpdateItem mTVBrowserTestItem;
    public static final String FALLBACK_PLUGINS_GZ_URL = "http://download.tvbrowser.org/plugins/plugins.gz";

    public SoftwareUpdater(URL url, PluginBaseInfo[] baseInfos) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtilities.openSaveGZipInputStream(IOUtilities.getStream(url, 300000)), "ISO-8859-15"));
        this.mSoftwareUpdateItems = this.readSoftwareUpdateItems(reader, 1, false, baseInfos);
        reader.close();
    }

    public SoftwareUpdater(URL url, int dialogType, PluginBaseInfo[] baseInfos) throws IOException {
        File pluginsGZ = new File(Settings.getUserSettingsDirName(), "plugins.gz");
        IOUtilities.download(url, pluginsGZ);
        if (!pluginsGZ.isFile() || pluginsGZ.length() < 100L) {
            IOUtilities.download(new URL(FALLBACK_PLUGINS_GZ_URL), pluginsGZ);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtilities.openSaveGZipInputStream(new FileInputStream(pluginsGZ)), "ISO-8859-15"));
        this.mSoftwareUpdateItems = this.readSoftwareUpdateItems(reader, dialogType, false, baseInfos);
        reader.close();
        if (!pluginsGZ.delete()) {
            pluginsGZ.deleteOnExit();
        }
    }

    SoftwareUpdater(URL url, int dialogType, boolean dragNdrop) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtilities.openSaveGZipInputStream(IOUtilities.getStream(url, 300000)), "ISO-8859-15"));
        this.mSoftwareUpdateItems = this.readSoftwareUpdateItems(reader, dialogType, dragNdrop, null);
        reader.close();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SoftwareUpdateItem[] readSoftwareUpdateItems(BufferedReader reader, int dialogType, boolean dragNdrop, PluginBaseInfo[] baseInfos) throws IOException {
        Pattern pluginTypePattern = Pattern.compile("\\[(.*):(.*)\\]");
        Pattern keyValuePattern = Pattern.compile("(.+?)=(.*)");
        ArrayList<void> updateItems = new ArrayList<void>();
        try {
            Object var9_8 = null;
            String line = reader.readLine();
            while (line != null) {
                void var9_9;
                Matcher matcher = pluginTypePattern.matcher(line);
                if (matcher.find()) {
                    String type = matcher.group(1);
                    String className = matcher.group(2);
                    if ("plugin".equals(type)) {
                        PluginSoftwareUpdateItem pluginSoftwareUpdateItem = new PluginSoftwareUpdateItem(className);
                    } else if ("dataservice".equals(type)) {
                        DataServiceSoftwareUpdateItem dataServiceSoftwareUpdateItem = new DataServiceSoftwareUpdateItem(className);
                    } else if ("tvbrowser".equals(type)) {
                        TvbrowserSoftwareUpdateItem tvbrowserSoftwareUpdateItem = new TvbrowserSoftwareUpdateItem(className);
                    }
                    if (var9_9 == null) {
                        throw new IOException("invalid software update file");
                    }
                    updateItems.add(var9_9);
                } else {
                    matcher = keyValuePattern.matcher(line);
                    if (matcher.find()) {
                        String value = matcher.group(2);
                        value = value.replaceAll("\\\\", "");
                        if (var9_9 != null) {
                            var9_9.addProperty(matcher.group(1), value);
                        }
                    }
                }
                line = reader.readLine();
            }
            this.mIsRequestingBlockArrayClear = true;
            Settings.Plugins.BLOCKED_ARRAY.clear(this);
            this.mIsRequestingBlockArrayClear = false;
            Iterator it = updateItems.iterator();
            while (it.hasNext()) {
                String className;
                SoftwareUpdateItem item;
                block35: {
                    item = (SoftwareUpdateItem)it.next();
                    className = item.getClassName();
                    Version required = item.getRequiredVersion();
                    Version maximum = item.getMaximumVersion();
                    if (required != null && TVBrowser.VERSION.compareTo(required) < 0 || maximum != null && TVBrowser.VERSION.compareTo(maximum) > 0 || !item.getProperty("filename").toLowerCase().endsWith(".jar") || !item.isSupportingCurrentOs()) {
                        if (required != null && maximum != null && required.compareTo(maximum) > 0) {
                            if (item instanceof PluginsSoftwareUpdateItem) {
                                PluginsSoftwareUpdateItem blocked = (PluginsSoftwareUpdateItem)item;
                                this.mBlockRequestingPluginId = blocked.getId();
                                Settings.Plugins.BLOCKED_ARRAY.addBlockedPlugin(this, this.mBlockRequestingPluginId, blocked.getMaximumVersion(), blocked.getRequiredVersion());
                                this.mBlockRequestingPluginId = null;
                                it.remove();
                                continue;
                            }
                            break block35;
                        } else {
                            it.remove();
                            continue;
                        }
                    }
                    if (item instanceof TvbrowserSoftwareUpdateItem && item.getClassName().endsWith(".stable")) {
                        Settings.General.VERSION_AVAILABLE.setVersion(item.getVersion());
                        it.remove();
                        continue;
                    }
                    if (item instanceof TvbrowserSoftwareUpdateItem) {
                        if (item.getClassName().endsWith(".test")) {
                            this.mTVBrowserTestItem = (TvbrowserSoftwareUpdateItem)item;
                        }
                        it.remove();
                        continue;
                    }
                }
                if (item.isAccessControl() && !Settings.Plugins.ACCESS_CONTROL.containsItem(className.toLowerCase())) {
                    Settings.Plugins.ACCESS_CONTROL.addItem(className.toLowerCase());
                } else if (!item.isAccessControl() && Settings.Plugins.ACCESS_CONTROL.containsItem(className.toLowerCase())) {
                    Settings.Plugins.ACCESS_CONTROL.removeItem(className.toLowerCase());
                }
                String pluginId = "java." + className.toLowerCase() + "." + className;
                if (baseInfos == null) {
                    TvDataServiceProxy service;
                    PluginProxy installedPlugin = PluginProxyManager.getInstance().getPluginForId(pluginId);
                    if (dialogType == 1) {
                        if (installedPlugin == null && (service = TvDataServiceProxyManager.getInstance().findDataServiceById(className.toLowerCase() + "." + className)) == null) {
                            it.remove();
                            continue;
                        }
                    } else if (dialogType == 2 && !item.getCategory().equals("datasources_soft") && !item.getCategory().equals("datasources_hard")) {
                        it.remove();
                        continue;
                    }
                    if (installedPlugin != null && (installedPlugin.getInfo().getVersion().compareTo(item.getVersion()) > 0 || installedPlugin.getInfo().getVersion().compareTo(item.getVersion()) == 0 && (!dragNdrop && (TVBrowser.VERSION.isStable() || Settings.Plugins.BETA_UPDATE_NO.getBoolean()) || item.getVersion().isStable()))) {
                        it.remove();
                        continue;
                    }
                    service = TvDataServiceProxyManager.getInstance().findDataServiceById(className.toLowerCase() + "." + className);
                    if (service != null && (service.getInfo().getVersion().compareTo(item.getVersion()) > 0 || service.getInfo().getVersion().compareTo(item.getVersion()) == 0 && (!dragNdrop && (TVBrowser.VERSION.isStable() || Settings.Plugins.BETA_UPDATE_NO.getBoolean()) || item.getVersion().isStable()))) {
                        it.remove();
                        continue;
                    }
                    if (item.isOnlyUpdate() && installedPlugin == null && service == null) {
                        it.remove();
                    }
                    if (item.isAlreadyInstalled() && item.getInstalledVersion().compareTo(item.getVersion()) < 0) {
                        item.setPreSelected(true);
                    }
                    PluginProxyManager.getInstance().firePluginBlockListRenewed();
                    continue;
                }
                PluginBaseInfo baseInfo = this.getBaseInfoFor(pluginId, baseInfos);
                if (baseInfo == null && !item.getCategory().equals("datasources_soft") && !item.getCategory().equals("datasources_hard")) {
                    it.remove();
                    continue;
                }
                if (baseInfo != null && baseInfo.getVersion().compareTo(item.getVersion()) >= 0) {
                    it.remove();
                    continue;
                }
                if (baseInfo == null) continue;
                item.setPreSelected(true);
            }
            return updateItems.toArray(new SoftwareUpdateItem[updateItems.size()]);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return updateItems.toArray(new SoftwareUpdateItem[updateItems.size()]);
    }

    public SoftwareUpdateItem[] getAvailableSoftwareUpdateItems() {
        return this.mSoftwareUpdateItems;
    }

    public TvbrowserSoftwareUpdateItem getTVBrowserTestItem() {
        return this.mTVBrowserTestItem;
    }

    public boolean isRequestingToBlockAPlugin(String pluginId) {
        return this.mBlockRequestingPluginId != null && pluginId != null && this.mBlockRequestingPluginId.equals(pluginId);
    }

    public boolean isRequestingBlockArrayClear() {
        return this.mIsRequestingBlockArrayClear;
    }

    private PluginBaseInfo getBaseInfoFor(String className, PluginBaseInfo[] availablePlugins) {
        for (PluginBaseInfo baseInfo : availablePlugins) {
            if (!baseInfo.getPluginId().equals(className)) continue;
            return baseInfo;
        }
        return null;
    }
}

