/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MarkedProgramsMap;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;

public class GenericPluginFilterSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(GenericPluginFilterSettingsTab.class);
    private SelectableItemList<PluginProxy> mGenericPluginFilterList;
    private ArrayList<PluginProxy> mCurrentlySelecteedList;

    @Override
    public JPanel createSettingsPanel() {
        PluginProxy[] currentlySelected = GenericFilterMap.getInstance().getActivatedGenericPluginFilterProxies();
        PluginProxy[] allPlugins = PluginProxyManager.getInstance().getActivatedPlugins();
        Arrays.sort(allPlugins, new Comparator<PluginProxy>(){

            @Override
            public int compare(PluginProxy o1, PluginProxy o2) {
                return o1.getInfo().getName().compareTo(o2.getInfo().getName());
            }
        });
        this.mCurrentlySelecteedList = new ArrayList();
        this.mCurrentlySelecteedList.addAll(Arrays.asList(currentlySelected));
        this.mGenericPluginFilterList = new SelectableItemList<PluginProxy>(currentlySelected, allPlugins);
        this.mGenericPluginFilterList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.mGenericPluginFilterList);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JButton edit = new JButton(Localizer.getLocalization("i18n_edit"), TVBrowserIcons.edit(16));
        edit.addActionListener(e -> {
            EditFilterDlg editFilter;
            SelectableItem<PluginProxy> item = this.mGenericPluginFilterList.getSelectedValue();
            PluginProxy proxy = item.getItem();
            UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(proxy, false);
            if (filter == null) {
                filter = new UserFilter(proxy.getInfo().getName());
            }
            if ((editFilter = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, false)).getOkWasPressed()) {
                GenericFilterMap.getInstance().updateGenericPluginFilter(proxy, filter, item.isSelected());
            }
        });
        edit.setEnabled(false);
        this.mGenericPluginFilterList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                SelectableItem<PluginProxy> item;
                PluginProxy proxy;
                edit.setEnabled(e.getFirstIndex() >= 0);
                if (edit.isEnabled() && !this.mCurrentlySelecteedList.contains(proxy = (item = this.mGenericPluginFilterList.getSelectedValue()).getItem())) {
                    this.mCurrentlySelecteedList.add(proxy);
                }
            }
        });
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("10dlu,100dlu:grow,default,5dlu"));
        pb.border(Borders.DIALOG);
        pb.addSeparatorRowFull(false, this.getTitle());
        pb.addRow(UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "Activate and setup filter for each plugin to pre filter the highlightings and the context menu of the plugin. (Only for programs that are accepted by an activated filter can be hightlighted by the plugin and context menu can be shown.)")), 2, 2);
        pb.addGrowingRow(scrollPane, 2, 2);
        pb.addRow("3dlu,default", (Component)edit, 3);
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        List<PluginProxy> selectedPlugins = this.mGenericPluginFilterList.getSelectionList();
        ArrayList<PluginProxy> newSelection = new ArrayList<PluginProxy>();
        for (PluginProxy pluginProxy : selectedPlugins) {
            GenericFilterMap.getInstance().updateGenericPluginFilterActivated(pluginProxy, true);
            this.mCurrentlySelecteedList.remove(pluginProxy);
            newSelection.add(pluginProxy);
        }
        for (PluginProxy unselected : this.mCurrentlySelecteedList) {
            GenericFilterMap.getInstance().updateGenericPluginFilterActivated(unselected, false);
        }
        this.mCurrentlySelecteedList.clear();
        this.mCurrentlySelecteedList = null;
        this.mCurrentlySelecteedList = newSelection;
        GenericFilterMap.getInstance().storeGenericFilters();
        MarkedProgramsMap.getInstance().validateMarkings();
    }

    @Override
    public Icon getIcon() {
        return TVBrowserIcons.filter(16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Highlighting filters");
    }
}

