/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.SettingsTab;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ConfigMenuItem;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.contextmenu.DoNothingContextMenuItem;
import tvbrowser.core.contextmenu.LeaveFullScreenMenuItem;
import tvbrowser.core.contextmenu.SelectProgramContextMenuItem;
import tvbrowser.core.contextmenu.SeparatorMenuItem;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.settings.ContextMenuMouseActionSetting;
import util.ui.CustomComboBoxRenderer;
import util.ui.EnhancedPanelBuilder;
import util.ui.TVBrowserIcons;
import util.ui.html.HTMLTextHelper;

public class MouseSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(MouseSettingsTab.class);
    private static final String[] mLeftModifiersName = new String[]{LOCALIZER.msg("modifier.none", "None"), LOCALIZER.msg("modifier.ctrl", "Ctrl"), LOCALIZER.msg("modifier.ctrlShift", "Ctrl+Shift"), LOCALIZER.msg("modifier.ctrlAlt", "Ctrl+Alt"), LOCALIZER.msg("modifier.altShift", "Alt+Shift"), LOCALIZER.msg("modifier.ctrlAltShift", "Ctrl+Alt+Shift")};
    private static final int[] mLeftModifiersEx = new int[]{0, 128, 192, 640, 576, 704};
    private static final String[] mMiddleModifiersName = new String[]{LOCALIZER.msg("modifier.none", "None"), LOCALIZER.msg("modifier.ctrl", "Ctrl"), LOCALIZER.msg("modifier.shift", "Shift"), LOCALIZER.msg("modifier.ctrlShift", "Ctrl+Shift"), LOCALIZER.msg("modifier.ctrlAlt", "Ctrl+Alt"), LOCALIZER.msg("modifier.altShift", "Alt+Shift"), LOCALIZER.msg("modifier.ctrlAltShift", "Ctrl+Alt+Shift")};
    private static final int[] mMiddleModifiersEx = new int[]{0, 128, 64, 192, 640, 576, 704};
    private static final String[] MOUSE_BUTTON_TEXT = new String[]{LOCALIZER.msg("button.left", "Left"), LOCALIZER.msg("button.middle", "Middle")};
    private static final String[] CLICK_COUNT_TEXT = new String[]{LOCALIZER.msg("click.single", "Single"), LOCALIZER.msg("click.double", "Double")};
    private ArrayList<ContextMenuPanel> mMouseActions = new ArrayList();
    private JPanel mMainPanel;

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, pref, fill:pref:grow, 3dlu");
        EnhancedPanelBuilder contentPanel = new EnhancedPanelBuilder(layout);
        contentPanel.border(Borders.DIALOG);
        this.mMouseActions.clear();
        contentPanel.addSeparatorRowFull(LOCALIZER.msg("title", "Title"));
        contentPanel.addLabelRow(LOCALIZER.msg("MouseButtons", "Mouse Buttons:"), 2, 4);
        this.mMainPanel = new JPanel();
        this.mMainPanel.setLayout(new BoxLayout(this.mMainPanel, 1));
        contentPanel.addRow(this.mMainPanel, 2, 4);
        ContextMenuMouseActionSetting[] leftSingleClick = Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        ContextMenuMouseActionSetting[] leftDoubleClick = Settings.Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        ContextMenuMouseActionSetting[] middleSingleClick = Settings.Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        ContextMenuMouseActionSetting[] middleDoubleClick = Settings.Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.getContextMenuMouseActionArray();
        this.addListEntries(leftSingleClick, 1, 1);
        this.addListEntries(leftDoubleClick, 1, 2);
        this.addListEntries(middleSingleClick, 2, 1);
        this.addListEntries(middleDoubleClick, 2, 2);
        this.updateList();
        JButton add = new JButton(LOCALIZER.msg("add", "Add a new mouse action"), TVBrowserIcons.newIcon(16));
        add.addActionListener(e -> {
            ContextMenuMouseActionSetting setting = new ContextMenuMouseActionSetting(0, DoNothingContextMenuItem.getInstance().getId(), -1);
            ContextMenuPanel contextMenuPanel = new ContextMenuPanel(setting, 1, 1);
            this.mMouseActions.add(contextMenuPanel);
            this.mMainPanel.add(contextMenuPanel);
            this.mMainPanel.updateUI();
        });
        contentPanel.addRow(add, 2);
        return contentPanel.getPanel();
    }

    private void addListEntries(ContextMenuMouseActionSetting[] actions, int mouseButton, int clickCount) {
        for (ContextMenuMouseActionSetting setting : actions) {
            ContextMenuPanel contextMenuPanel = new ContextMenuPanel(setting, mouseButton, clickCount);
            this.mMouseActions.add(contextMenuPanel);
        }
    }

    private void updateList() {
        this.mMainPanel.removeAll();
        for (ContextMenuPanel panel : this.mMouseActions) {
            this.mMainPanel.add(panel);
        }
        this.mMainPanel.updateUI();
    }

    @Override
    public void saveSettings() {
        try {
            ArrayList<ContextMenuMouseActionSetting> singleLeft = new ArrayList<ContextMenuMouseActionSetting>();
            ArrayList<ContextMenuMouseActionSetting> doubleLeft = new ArrayList<ContextMenuMouseActionSetting>();
            ArrayList<ContextMenuMouseActionSetting> singleMiddle = new ArrayList<ContextMenuMouseActionSetting>();
            ArrayList<ContextMenuMouseActionSetting> doubleMiddle = new ArrayList<ContextMenuMouseActionSetting>();
            for (ContextMenuPanel mouseAction : this.mMouseActions) {
                ContextMenuMouseActionSetting setting = mouseAction.getSetting();
                if (mouseAction.isLeftMouseButton()) {
                    if (mouseAction.isSingleClick()) {
                        if (this.containsModifier(singleLeft, setting.getModifiersEx())) continue;
                        singleLeft.add(setting);
                        continue;
                    }
                    if (this.containsModifier(doubleLeft, setting.getModifiersEx())) continue;
                    doubleLeft.add(setting);
                    continue;
                }
                if (mouseAction.isSingleClick()) {
                    if (this.containsModifier(singleMiddle, setting.getModifiersEx())) continue;
                    singleMiddle.add(setting);
                    continue;
                }
                if (this.containsModifier(doubleMiddle, setting.getModifiersEx())) continue;
                doubleMiddle.add(setting);
            }
            Settings.Mouse.LEFT_SINGLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(singleLeft.toArray(new ContextMenuMouseActionSetting[singleLeft.size()]));
            Settings.Mouse.LEFT_DOUBLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(doubleLeft.toArray(new ContextMenuMouseActionSetting[doubleLeft.size()]));
            Settings.Mouse.MIDDLE_SINGLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(singleMiddle.toArray(new ContextMenuMouseActionSetting[singleMiddle.size()]));
            Settings.Mouse.MIDDLE_DOUBLE_CLICK_IF_ARRAY.setContextMenuMouseActionArray(doubleMiddle.toArray(new ContextMenuMouseActionSetting[doubleMiddle.size()]));
            ContextMenuManager.getInstance().init();
            MainFrame.getInstance().addKeyboardAction();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean containsModifier(ArrayList<ContextMenuMouseActionSetting> list, int modifier) {
        for (ContextMenuMouseActionSetting setting : list) {
            if (setting.getModifiersEx() != modifier) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("devices", "input-mouse", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "context menu");
    }

    private static void loadActionMenus(ActionMenu actionMenu, ArrayList<ActionMenu> result) {
        ActionMenu[] subItems;
        if (actionMenu != null && (subItems = actionMenu.getSubItems()) != null) {
            for (ActionMenu item : subItems) {
                if (item.hasSubItems()) {
                    MouseSettingsTab.loadActionMenus(item, result);
                    continue;
                }
                if (item.getActionId() == -1) continue;
                result.add(item);
            }
        }
    }

    private static final class ContextMenuActionEntry {
        private ContextMenuIf mContextMenuIf;
        private ActionMenu mActionMenu;

        public ContextMenuActionEntry(ContextMenuIf contextMenuIf, ActionMenu actionMenu) {
            this.mContextMenuIf = contextMenuIf;
            this.mActionMenu = actionMenu;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextMenuActionEntry) {
                return this.mContextMenuIf.equals(((ContextMenuActionEntry)obj).mContextMenuIf) && (this.mActionMenu == null && ((ContextMenuActionEntry)obj).mActionMenu == null || this.mActionMenu != null && ((ContextMenuActionEntry)obj).mActionMenu != null && this.mActionMenu.getActionId() == ((ContextMenuActionEntry)obj).mActionMenu.getActionId());
            }
            return super.equals(obj);
        }
    }

    private static class MouseClickSetting {
        private ContextMenuIf mClickInterface;
        private ActionMenu mActionMenu;
        private JComboBox<Object> mComboBox;

        public MouseClickSetting(ContextMenuIf clickIf, int actionMenuId) {
            this.mClickInterface = clickIf;
            if (clickIf != null) {
                this.mActionMenu = clickIf.getContextMenuActions(Plugin.getPluginManager().getExampleProgram());
                if (actionMenuId != -1) {
                    this.mActionMenu = ContextMenuManager.loadActionMenu(this.mActionMenu, actionMenuId);
                }
            } else {
                this.mActionMenu = new ActionMenu((Action)null);
            }
        }

        public ContextMenuActionEntry getSelectedContextMenuActionEntry() {
            return (ContextMenuActionEntry)this.mComboBox.getSelectedItem();
        }

        public JComboBox<Object> createComboxBox() {
            this.mComboBox = new JComboBox();
            this.mComboBox.setSelectedItem(new ContextMenuActionEntry(this.mClickInterface, this.mActionMenu));
            this.mComboBox.setMaximumRowCount(15);
            this.mComboBox.setRenderer(new ContextMenuCellRenderer(this.mComboBox.getRenderer()));
            this.mComboBox.removeAllItems();
            DoNothingContextMenuItem doNothing = DoNothingContextMenuItem.getInstance();
            this.mComboBox.addItem(new ContextMenuActionEntry(doNothing, doNothing.getContextMenuActions(null)));
            this.mComboBox.addItem(new ContextMenuActionEntry(SelectProgramContextMenuItem.getInstance(), SelectProgramContextMenuItem.getInstance().getContextMenuActions(null)));
            this.fillListBox();
            if (this.mClickInterface != null) {
                this.mComboBox.setSelectedItem(new ContextMenuActionEntry(this.mClickInterface, this.mActionMenu));
            } else {
                this.mComboBox.setSelectedItem(doNothing);
            }
            return this.mComboBox;
        }

        private void fillListBox() {
            ContextMenuIf[] menuIfList = ContextMenuManager.getInstance().getAvailableContextMenuIfs(true, false);
            Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
            for (ContextMenuIf element : menuIfList) {
                if (element instanceof SeparatorMenuItem || element instanceof ConfigMenuItem || element instanceof LeaveFullScreenMenuItem) continue;
                ActionMenu actionMenu = element.getContextMenuActions(exampleProgram);
                ArrayList<ActionMenu> listActionMenus = new ArrayList<ActionMenu>();
                MouseSettingsTab.loadActionMenus(actionMenu, listActionMenus);
                if (actionMenu != null && listActionMenus.isEmpty()) {
                    this.mComboBox.addItem(new ContextMenuActionEntry(element, actionMenu));
                    continue;
                }
                if (listActionMenus.isEmpty()) continue;
                for (ActionMenu menu : listActionMenus) {
                    this.mComboBox.addItem(new ContextMenuActionEntry(element, menu));
                }
            }
        }
    }

    private static class ContextMenuCellRenderer
    extends CustomComboBoxRenderer {
        public ContextMenuCellRenderer(ListCellRenderer<Object> backendRenderer) {
            super(backendRenderer);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.getBackendRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ContextMenuActionEntry) {
                ContextMenuIf menuIf = ((ContextMenuActionEntry)value).mContextMenuIf;
                StringBuilder text = new StringBuilder();
                Icon icon = null;
                ActionMenu actionMenu = ((ContextMenuActionEntry)value).mActionMenu;
                if (actionMenu != null) {
                    Action action = actionMenu.getAction();
                    if (action != null) {
                        text.append((String)action.getValue("Name"));
                        icon = (Icon)action.getValue("SmallIcon");
                    } else if (menuIf instanceof PluginProxy) {
                        text.append(((PluginProxy)menuIf).getInfo().getName());
                        icon = ((PluginProxy)menuIf).getMarkIcon();
                    } else {
                        text.append("unknown");
                        icon = null;
                    }
                }
                label.setIcon(icon);
                label.setText(HTMLTextHelper.checkTextForTextFormatingTags(text.toString()));
            }
            return label;
        }
    }

    private class ContextMenuPanel
    extends JPanel {
        private JComboBox<String> mMouseButton;
        private JComboBox<String> mModifiersEx;
        private JComboBox<String> mClickCount;
        private MouseClickSetting mMouseClickSetting;

        private ContextMenuPanel(ContextMenuMouseActionSetting setting, int mouseButton, int clickCount) {
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder("default,3dlu,default,3dlu,default,3dlu,default,3dlu,default", (JPanel)this);
            pb.addLabelRow(LOCALIZER.msg("mouseButton", "Mouse button"), 1);
            pb.labelAdd(LOCALIZER.msg("clickCount", "Click count"), 3);
            pb.labelAdd(LOCALIZER.msg("modifier", "Keyboard"), 5);
            pb.labelAdd(LOCALIZER.msg("action", "Action"), 7);
            this.mMouseButton = new JComboBox<String>(MOUSE_BUTTON_TEXT);
            this.mMouseButton.setSelectedIndex(mouseButton - 1);
            this.mModifiersEx = new JComboBox<String>(mouseButton == 1 ? mLeftModifiersName : mMiddleModifiersName);
            this.mModifiersEx.setSelectedIndex(this.indexOfModifier(mouseButton == 1 ? mLeftModifiersEx : mMiddleModifiersEx, setting.getModifiersEx()));
            this.mMouseClickSetting = new MouseClickSetting(setting.getContextMenuIf(), setting.getContextMenuActionId());
            this.mClickCount = new JComboBox<String>(CLICK_COUNT_TEXT);
            this.mClickCount.setSelectedIndex(clickCount - 1);
            this.mMouseButton.addItemListener(e -> {
                block4: {
                    if (e.getStateChange() != 1) break block4;
                    ((DefaultComboBoxModel)this.mModifiersEx.getModel()).removeAllElements();
                    if (e.getItem().equals(MOUSE_BUTTON_TEXT[0])) {
                        for (String name1 : mLeftModifiersName) {
                            ((DefaultComboBoxModel)this.mModifiersEx.getModel()).addElement(name1);
                        }
                    } else {
                        for (String name2 : mMiddleModifiersName) {
                            ((DefaultComboBoxModel)this.mModifiersEx.getModel()).addElement(name2);
                        }
                    }
                }
            });
            JButton delete = new JButton(TVBrowserIcons.delete(16));
            delete.setToolTipText(Localizer.getLocalization("i18n_delete"));
            delete.addActionListener(e -> {
                MouseSettingsTab.this.mMouseActions.remove(this);
                MouseSettingsTab.this.mMainPanel.remove(this);
                MouseSettingsTab.this.mMainPanel.updateUI();
            });
            pb.addRow(this.mMouseButton, 1);
            pb.add(this.mClickCount, 3);
            pb.add(this.mModifiersEx, 5);
            pb.add(this.mMouseClickSetting.createComboxBox(), 7);
            pb.add(delete, 9);
        }

        private int indexOfModifier(int[] modifierExArr, int modifierEx) {
            for (int i = 0; i < modifierExArr.length; ++i) {
                if (modifierExArr[i] != modifierEx) continue;
                return i;
            }
            return 0;
        }

        public ContextMenuMouseActionSetting getSetting() {
            int mouseButton = this.mMouseButton.getSelectedIndex() + 1;
            ContextMenuActionEntry selected = this.mMouseClickSetting.getSelectedContextMenuActionEntry();
            int modifierEx = mouseButton == 1 ? mLeftModifiersEx[this.mModifiersEx.getSelectedIndex()] : mMiddleModifiersEx[this.mModifiersEx.getSelectedIndex()];
            ContextMenuMouseActionSetting setting = new ContextMenuMouseActionSetting(modifierEx, selected.mContextMenuIf.getId(), selected.mActionMenu.getActionId());
            return setting;
        }

        public boolean isLeftMouseButton() {
            return this.mMouseButton.getSelectedIndex() == 0;
        }

        public boolean isSingleClick() {
            return this.mClickCount.getSelectedIndex() == 0;
        }
    }
}

