/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.ChannelGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.tvdataservice.ChannelGroupManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import util.browserlauncher.Launch;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.html.ExtendedHTMLDocument;
import util.ui.html.ExtendedHTMLEditorKit;
import util.ui.html.HTMLTextHelper;

public class ChannelGroupInfoDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelGroupInfoDialog.class);
    private ChannelGroup mChannelGroup;

    public ChannelGroupInfoDialog(JDialog dialog, ChannelGroup group) {
        super((Dialog)dialog, true);
        this.setTitle(group.getName());
        this.mChannelGroup = group;
        this.initGui();
    }

    private void initGui() {
        UiUtilities.registerForClosing(this);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(Borders.DLU4);
        panel.setLayout((LayoutManager)new FormLayout("fill:default:grow, default", "fill:default:grow, 3dlu, default"));
        CellConstraints cc = new CellConstraints();
        JEditorPane infoPanel = new JEditorPane();
        infoPanel.setEditorKit(new ExtendedHTMLEditorKit());
        ExtendedHTMLDocument doc = (ExtendedHTMLDocument)infoPanel.getDocument();
        infoPanel.setEditable(false);
        infoPanel.setText(this.generateHtml(doc));
        infoPanel.addHyperlinkListener(evt -> {
            URL url;
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = evt.getURL()) != null) {
                Launch.openURL(url.toString());
            }
        });
        JScrollPane scrollPane = new JScrollPane(infoPanel);
        panel.add((Component)scrollPane, cc.xyw(1, 1, 2));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> this.setVisible(false));
        SwingUtilities.invokeLater(() -> infoPanel.scrollRectToVisible(new Rectangle(0, 0)));
        panel.add((Component)ok, cc.xy(2, 3));
        this.setSize(500, 350);
    }

    private String getNotNull(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "<unknown>";
        }
        return s;
    }

    private String generateHtml(ExtendedHTMLDocument doc) {
        Channel[] ch;
        StringBuilder html = new StringBuilder(1024);
        html.append("<html><style type=\"text/css\" media=\"screen\"><!--body {font-size:12px;font-family:Dialog;}h1 {font-size:12px;font-family:Dialog;font-weight:bold;}--></style><body>");
        html.append("<table><tr><td valign=\"top\"><b>").append(this.mChannelGroup.getName()).append("</b></td></tr></table>");
        html.append("<h1>").append(mLocalizer.msg("provider", "Provider")).append("</h1>");
        html.append(HTMLTextHelper.convertTextToHtml(this.getNotNull(this.mChannelGroup.getProviderName()), true));
        html.append("<h1>").append(mLocalizer.msg("description", "Description")).append("</h1>");
        html.append(HTMLTextHelper.convertTextToHtml(this.getNotNull(this.mChannelGroup.getDescription()), true));
        html.append("<h1>").append(Localizer.getLocalization("i18n_channels")).append("</h1>");
        TvDataServiceProxy proxy = ChannelGroupManager.getInstance().getTvDataService(this.mChannelGroup);
        if (proxy != null && (ch = proxy.getAvailableChannels(this.mChannelGroup)) != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < ch.length - 1; ++i) {
                buf.append(ch[i].getName()).append(", ");
            }
            if (ch.length > 0) {
                buf.append(ch[ch.length - 1].getName());
            }
            html.append(HTMLTextHelper.convertTextToHtml(buf.toString(), false));
        }
        html.append("</body></html>");
        return html.toString();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

