/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import com.jgoodies.forms.layout.FormLayout;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;

public class SingleColorBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(SingleColorBackgroundStyle.class);
    private ColorLabel mColorLabel;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default,5dlu,default", "default"));
        this.mColorLabel = new ColorLabel(Settings.ProgramTable.COLOR_BACKGROUND_SINGLE.getColor());
        this.mColorLabel.setStandardColor(Settings.ProgramTable.COLOR_BACKGROUND_SINGLE.getDefaultColor());
        ColorButton colorButton = new ColorButton(this.mColorLabel);
        pb.labelAdd(LOCALIZER.msg("text", "Background color"), 1);
        pb.add(this.mColorLabel, 3);
        pb.add(colorButton, 5);
        return pb.getPanel();
    }

    @Override
    public void storeSettings() {
        Settings.ProgramTable.COLOR_BACKGROUND_SINGLE.setColor(this.mColorLabel.getColor());
    }

    @Override
    public String getName() {
        return LOCALIZER.msg("style", "Single color");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "singleColor";
    }
}

