/*
 * Decompiled with CFR 0.152.
 */
package util.programmouseevent;

import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import tvbrowser.core.contextmenu.ContextMenuManager;
import util.programmouseevent.ProgramContextMenuListener;
import util.programmouseevent.ProgramMouseActionListener;
import util.programmouseevent.ProgramMouseAndContextMenuListener;

public class ProgramMouseEventHandler
extends MouseAdapter {
    private ProgramMouseAndContextMenuListener mContextMenuListener;
    private ContextMenuIf mOwner;
    private Thread mSingleClickThread;
    private boolean mPerformingSingleClick = false;

    public ProgramMouseEventHandler(ProgramMouseAndContextMenuListener listener, ContextMenuIf owner) {
        this.mContextMenuListener = listener;
        this.mOwner = owner;
    }

    public void setOwner(ContextMenuIf owner) {
        this.mOwner = owner;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mContextMenuListener instanceof ProgramMouseActionListener) {
            Program prog = this.mContextMenuListener.getProgramForMouseEvent(e);
            if (e.getClickCount() == 1) {
                this.performSingleClick(prog, e);
            } else if (e.getClickCount() == 2) {
                this.performDoubleClick(prog, e);
            }
        }
    }

    private void performSingleClick(final Program prog, final MouseEvent e) {
        this.mSingleClickThread = new Thread("Single click"){

            @Override
            public void run() {
                try {
                    ProgramMouseEventHandler.this.mPerformingSingleClick = false;
                    1.sleep(Plugin.SINGLE_CLICK_WAITING_TIME);
                    ProgramMouseEventHandler.this.mPerformingSingleClick = true;
                    ProgramMouseEventHandler.handleProgramClick(prog, ProgramMouseEventHandler.this.mOwner, true, e);
                    ProgramMouseEventHandler.this.mPerformingSingleClick = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.mSingleClickThread.setPriority(1);
        this.mSingleClickThread.start();
    }

    private void performDoubleClick(Program prog, MouseEvent e) {
        if (!this.mPerformingSingleClick && this.mSingleClickThread != null && this.mSingleClickThread.isAlive()) {
            this.mSingleClickThread.interrupt();
        }
        if (!this.mPerformingSingleClick) {
            ProgramMouseEventHandler.handleProgramClick(prog, this.mOwner, false, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.testAndHandleContextMenuEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.testAndHandleContextMenuEvent(e);
    }

    private void testAndHandleContextMenuEvent(MouseEvent e) {
        if (this.mContextMenuListener instanceof ProgramContextMenuListener && e.isPopupTrigger()) {
            this.mContextMenuListener.showContextMenu(e);
        }
    }

    public static void handleProgramClick(Program program, ContextMenuIf caller, boolean singleClick, MouseEvent e) {
        ContextMenuManager.ContextMenuAction contextMenuAction;
        if (program == null || e == null) {
            return;
        }
        ContextMenuManager.ContextMenuAction contextMenuAction2 = contextMenuAction = singleClick ? ContextMenuManager.getInstance().getContextMenuForSingleClick(e) : ContextMenuManager.getInstance().getContextMenuForDoubleClick(e);
        if (contextMenuAction == null) {
            return;
        }
        if (caller != null && contextMenuAction.getContextMenuIf().getId().equals(caller.getId())) {
            return;
        }
        ProgramMouseEventHandler.handleAction(program, contextMenuAction.getContextMenuIf().getContextMenuActions(program), contextMenuAction.getContextMenuActionId());
    }

    public static void handleAction(Program program, ActionMenu menu) {
        ProgramMouseEventHandler.handleAction(program, menu, -1);
    }

    public static void handleAction(Program program, ActionMenu menu, int actionId) {
        Action action = null;
        if (actionId != -1) {
            ActionMenu actionMenu = ContextMenuManager.loadActionMenu(menu, actionId);
            if (actionMenu != null) {
                action = actionMenu.getAction();
            }
        } else {
            while (menu != null && menu.hasSubItems()) {
                ActionMenu[] subItems = menu.getSubItems();
                if (subItems.length > 0) {
                    menu = subItems[0];
                    continue;
                }
                menu = null;
            }
            if (menu == null) {
                return;
            }
            action = menu.getAction();
        }
        if (action != null) {
            ActionEvent evt = new ActionEvent(program, 0, (String)action.getValue("ActionCommandKey"));
            action.actionPerformed(evt);
        }
    }
}

