/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import java.awt.Font;
import util.settings.Property;
import util.settings.PropertyManager;

public class FontProperty
extends Property {
    private Font mDefaultValue;
    private Font mCachedValue;

    public FontProperty(PropertyManager manager, String key, Font defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public Font getDefault() {
        return this.mDefaultValue;
    }

    public Font getFont() {
        if (this.mCachedValue == null) {
            String[] splits;
            String asString = this.getProperty();
            if (asString != null && (splits = asString.split(",")).length == 3) {
                try {
                    String name = splits[0];
                    int style = Integer.parseInt(splits[1]);
                    int size = Integer.parseInt(splits[2]);
                    this.mCachedValue = new Font(name, style, size);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.getDefault();
            }
        }
        return this.mCachedValue;
    }

    public void setFont(Font value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        if (value.equals(this.getDefault())) {
            this.setProperty(null);
        } else {
            String asString = value.getName() + "," + value.getStyle() + "," + value.getSize();
            this.setProperty(asString);
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

