/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import org.apache.commons.lang3.StringUtils;
import util.settings.Property;
import util.settings.PropertyManager;

public class IntArrayProperty
extends Property {
    private int[] mDefaultValue;
    private int[] mCachedValue;

    public IntArrayProperty(PropertyManager manager, String key, int[] defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public int[] getDefault() {
        return this.mDefaultValue;
    }

    public int[] getIntArray() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            if (asString != null && asString.length() > 0) {
                String[] splits = asString.split(",");
                try {
                    int[] intArr = new int[splits.length];
                    for (int i = 0; i < intArr.length; ++i) {
                        intArr[i] = Integer.parseInt(splits[i]);
                    }
                    this.mCachedValue = intArr;
                }
                catch (NumberFormatException exc) {
                    exc.printStackTrace();
                }
            } else if (asString != null && StringUtils.isEmpty((CharSequence)asString)) {
                this.mCachedValue = new int[0];
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setIntArray(int[] value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        boolean equalsDefault = false;
        if (this.mDefaultValue != null && value.length == this.mDefaultValue.length) {
            equalsDefault = true;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == this.mDefaultValue[i]) continue;
                equalsDefault = false;
                break;
            }
        }
        if (equalsDefault) {
            this.setProperty(null);
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < value.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(value[i]);
            }
            this.setProperty(buffer.toString());
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

